/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public interface HkdfMacFactory {
    public Mac createInstance(byte[] var1);

    public static final class Default
    implements HkdfMacFactory {
        private final String macAlgorithmName;
        private final Provider provider;

        public static HkdfMacFactory hmacSha256() {
            return new Default("HmacSHA256", null);
        }

        public static HkdfMacFactory hmacSha512() {
            return new Default("HmacSHA512", null);
        }

        @Deprecated
        public static HkdfMacFactory hmacSha1() {
            return new Default("HmacSHA1", null);
        }

        public Default(String macAlgorithmName) {
            this(macAlgorithmName, null);
        }

        public Default(String macAlgorithmName, Provider provider) {
            this.macAlgorithmName = macAlgorithmName;
            this.provider = provider;
        }

        @Override
        public Mac createInstance(byte[] key) {
            try {
                SecretKeySpec secretKey = new SecretKeySpec(key, this.macAlgorithmName);
                Mac hmacInstance = this.provider == null ? Mac.getInstance(this.macAlgorithmName) : Mac.getInstance(this.macAlgorithmName, this.provider);
                hmacInstance.init(secretKey);
                return hmacInstance;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("defined mac algorithm was not found", e);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not make hmac hasher in hkdf", e);
            }
        }
    }
}

