/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.aml;

import java.time.Instant;
import java.util.Objects;

public final class AmlMessage {
    private final Integer version;
    private final Double latitude;
    private final Double longitude;
    private final Double radiusMeters;
    private final String imsi;
    private final String imei;
    private final Instant timeOfPositioning;
    private final Integer levelOfConfidence;
    private final PositioningMethod positionMethod;
    private final String mcc;
    private final String mnc;
    private final Integer length;

    public AmlMessage(Integer version, Double latitude, Double longitude, Double radiusMeters, String imsi, String imei, Instant timeOfPositioning, Integer levelOfConfidence, PositioningMethod positionMethod, String mcc, String mnc, Integer length) {
        this.version = version;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusMeters = radiusMeters;
        this.imsi = imsi;
        this.imei = imei;
        this.timeOfPositioning = timeOfPositioning;
        this.levelOfConfidence = levelOfConfidence;
        this.positionMethod = positionMethod;
        this.mcc = mcc;
        this.mnc = mnc;
        this.length = length;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getRadiusMeters() {
        return this.radiusMeters;
    }

    public String getImsi() {
        return this.imsi;
    }

    public String getImei() {
        return this.imei;
    }

    public Instant getTimeOfPositioning() {
        return this.timeOfPositioning;
    }

    public Integer getLevelOfConfidence() {
        return this.levelOfConfidence;
    }

    public PositioningMethod getPositionMethod() {
        return this.positionMethod;
    }

    public String getMcc() {
        return this.mcc;
    }

    public String getMnc() {
        return this.mnc;
    }

    public Integer getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmlMessage that = (AmlMessage)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.latitude, that.latitude) && Objects.equals(this.longitude, that.longitude) && Objects.equals(this.radiusMeters, that.radiusMeters) && Objects.equals(this.imsi, that.imsi) && Objects.equals(this.imei, that.imei) && Objects.equals(this.timeOfPositioning, that.timeOfPositioning) && Objects.equals(this.levelOfConfidence, that.levelOfConfidence) && this.positionMethod == that.positionMethod && Objects.equals(this.mcc, that.mcc) && Objects.equals(this.mnc, that.mnc) && Objects.equals(this.length, that.length);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.latitude, this.longitude, this.radiusMeters, this.imsi, this.imei, this.timeOfPositioning, this.levelOfConfidence, this.positionMethod, this.mcc, this.mnc, this.length});
    }

    public String toString() {
        return "AmlMessage{version=" + this.version + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", radiusMeters=" + this.radiusMeters + ", imsi='" + this.imsi + '\'' + ", imei='" + this.imei + '\'' + ", timeOfPositioning=" + this.timeOfPositioning + ", levelOfConfidence=" + this.levelOfConfidence + ", positionMethod=" + (Object)((Object)this.positionMethod) + ", mcc='" + this.mcc + '\'' + ", mnc='" + this.mnc + '\'' + ", length=" + this.length + '}';
    }

    public static enum PositioningMethod {
        GNSS,
        WIFI_SIGNAL,
        CELL,
        NO_LOCATION;

    }
}

