/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.aml;

import at.gridgears.aml.AmlMessage;
import at.gridgears.aml.AmlMessageBuilder;
import at.gridgears.aml.Attribute;
import at.gridgears.aml.Attributes;
import at.gridgears.aml.Settings;
import at.gridgears.aml.exceptions.AmlParseException;
import at.gridgears.aml.exceptions.AmlValidationException;
import at.gridgears.aml.validation.Validator;
import java.time.Instant;
import java.util.Objects;

public class AmlMessageParser {
    private final Validator validator;

    public AmlMessageParser() {
        this(new Settings());
    }

    public AmlMessageParser(Settings settings) {
        this.validator = settings.getValidator();
    }

    public AmlMessage parse(String message) throws AmlParseException, AmlValidationException {
        Attributes attributes = Attributes.parse(message);
        this.checkMessageLength(message, attributes);
        this.checkAttributes(attributes);
        AmlMessageBuilder builder = AmlMessageBuilder.newAdvancedMobileLocation().version(this.getHeaderValue(attributes)).latitude(this.getLatitude(attributes)).longitude(this.getLongitude(attributes)).radiusMeters(this.getRadius(attributes)).imei(this.getImei(attributes)).imsi(this.getImsi(attributes)).levelOfConfidence(this.getLoc(attributes)).mcc(this.getMcc(attributes)).mnc(this.getMnc(attributes)).timeOfPositioning(this.getTop(attributes)).positionMethod(this.getPositioningMethod(attributes)).length(this.getMessageLength(attributes));
        return this.validator.validate(builder.build());
    }

    private void checkAttributes(Attributes attributes) throws AmlParseException {
        attributes.check();
    }

    private void checkMessageLength(String message, Attributes attributes) throws AmlParseException {
        Integer actualMessageLength;
        Integer expectedMessageLength = this.getMessageLength(attributes);
        if (!Objects.equals(expectedMessageLength, actualMessageLength = Integer.valueOf(message.length()))) {
            throw new AmlParseException("expected message length " + expectedMessageLength + " but was " + actualMessageLength);
        }
    }

    private Integer getHeaderValue(Attributes attributes) throws AmlParseException {
        return attributes.get("A\"ML", Attribute::getIntegerValue);
    }

    private Double getLatitude(Attributes attributes) throws AmlParseException {
        return attributes.get("lt", Attribute::getDoubleValue);
    }

    private Double getLongitude(Attributes attributes) throws AmlParseException {
        return attributes.get("lg", Attribute::getDoubleValue);
    }

    private Double getRadius(Attributes attributes) throws AmlParseException {
        return attributes.get("rd", Attribute::getDoubleValue);
    }

    private Instant getTop(Attributes attributes) throws AmlParseException {
        return attributes.get("top", Attribute::getInstantValue);
    }

    private Integer getLoc(Attributes attributes) throws AmlParseException {
        return attributes.get("lc", Attribute::getIntegerValue);
    }

    private AmlMessage.PositioningMethod getPositioningMethod(Attributes attributes) throws AmlParseException {
        return attributes.get("pm", Attribute::getPositioningMethod);
    }

    private String getImsi(Attributes attributes) throws AmlParseException {
        return attributes.get("si", Attribute::getStringValue);
    }

    private String getImei(Attributes attributes) throws AmlParseException {
        return attributes.get("ei", Attribute::getStringValue);
    }

    private String getMcc(Attributes attributes) throws AmlParseException {
        return attributes.get("mcc", Attribute::getStringValue);
    }

    private String getMnc(Attributes attributes) throws AmlParseException {
        return attributes.get("mnc", Attribute::getStringValue);
    }

    private Integer getMessageLength(Attributes attributes) throws AmlParseException {
        return attributes.get("ml", Attribute::getIntegerValue);
    }
}

