/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held;

import at.gridgears.held.FindLocationError;
import at.gridgears.held.Location;
import at.gridgears.held.LocationReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class FindLocationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_LOCATION_UNKNOWN = "locationUnknown";
    private final FindLocationError error;
    private final List<Location> locations;
    private final List<LocationReference> locationReferences;

    private FindLocationResult(List<Location> locations, List<LocationReference> locationReferences, @Nullable FindLocationError error) {
        Validate.noNullElements(locations, (String)"locations must not be null or contain null elements", (Object[])new Object[0]);
        Validate.noNullElements(locationReferences, (String)"locationReferences must not be null or contain null elements", (Object[])new Object[0]);
        this.error = error;
        this.locations = Collections.unmodifiableList(new ArrayList<Location>(locations));
        this.locationReferences = Collections.unmodifiableList(new ArrayList<LocationReference>(locationReferences));
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public List<LocationReference> getLocationReferences() {
        return this.locationReferences;
    }

    public Optional<FindLocationError> getError() {
        return Optional.ofNullable(this.error);
    }

    public Status getStatus() {
        Status result = !this.locations.isEmpty() || !this.locationReferences.isEmpty() ? Status.FOUND : (this.error.getCode().equals(ERROR_LOCATION_UNKNOWN) ? Status.NOT_FOUND : Status.ERROR);
        return result;
    }

    public static FindLocationResult createFailureResult(FindLocationError error) {
        Validate.notNull((Object)error, (String)"error must not be null", (Object[])new Object[0]);
        return new FindLocationResult(Collections.emptyList(), Collections.emptyList(), error);
    }

    public static FindLocationResult createFoundResult(List<Location> locations, List<LocationReference> locationReferences) {
        if (locations.isEmpty() && locationReferences.isEmpty()) {
            throw new IllegalArgumentException("locations and locationReferences must not both be empty for a success result");
        }
        return new FindLocationResult(locations, locationReferences, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindLocationResult that = (FindLocationResult)o;
        return Objects.equals(this.error, that.error) && Objects.equals(this.locations, that.locations) && Objects.equals(this.locationReferences, that.locationReferences);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.locations, this.locationReferences);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("error", (Object)this.error).append("locations", this.locations).append("locationReferences", this.locationReferences).toString();
    }

    public static enum Status {
        FOUND,
        NOT_FOUND,
        ERROR;

    }
}

