/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;

public class HeldClientConfig {
    private final URI uri;
    private final String language;
    private final List<Header> requestHeaders;

    public HeldClientConfig(URI uri, String language, List<Header> requestHeaders) {
        Validate.notNull((Object)uri, (String)"uri must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)language, (String)"language must not be null", (Object[])new Object[0]);
        Validate.noNullElements(requestHeaders, (String)"requestHeaders must not be null or contain null elements", (Object[])new Object[0]);
        this.language = language;
        this.requestHeaders = Collections.unmodifiableList(new ArrayList<Header>(requestHeaders));
        this.uri = uri;
    }

    URI getUri() {
        return this.uri;
    }

    String getLanguage() {
        return this.language;
    }

    List<Header> getRequestHeaders() {
        return this.requestHeaders;
    }
}

