/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held.internal.parser;

import at.gridgears.held.FindLocationError;
import at.gridgears.schemas.held.ErrorMsgType;
import at.gridgears.schemas.held.ErrorType;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;

class ErrorResultParser {
    private static final String DEFAULT_LANGUAGE = "en";
    private final String language;

    ErrorResultParser(String language) {
        this.language = language;
        Validate.notEmpty((CharSequence)language, (String)"language must not be null or empty", (Object[])new Object[0]);
    }

    FindLocationError parse(ErrorType errorType) {
        return new FindLocationError(errorType.getCode(), this.getLocalizedMessage(errorType.getMessage()));
    }

    private String getLocalizedMessage(List<ErrorMsgType> messages) {
        String result = this.getMessageWithLanguage(messages, this.language);
        if (result == null && (result = this.getMessageWithLanguage(messages, DEFAULT_LANGUAGE)) == null) {
            result = !messages.isEmpty() ? messages.get(0).getValue() : "";
        }
        return result;
    }

    private String getMessageWithLanguage(List<ErrorMsgType> messages, String messageLanguage) {
        return messages.stream().filter(msg -> this.isLang((ErrorMsgType)msg, messageLanguage)).findFirst().map(ErrorMsgType::getValue).orElse(null);
    }

    private boolean isLang(ErrorMsgType msg, String messageLanguage) {
        return msg.getOtherAttributes().entrySet().stream().anyMatch(entry -> ((QName)entry.getKey()).getLocalPart().equals("lang") && ((String)entry.getValue()).equals(messageLanguage));
    }
}

