/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held.internal.parser;

import at.gridgears.held.FindLocationResult;
import at.gridgears.held.Location;
import at.gridgears.held.LocationReference;
import at.gridgears.held.internal.parser.ErrorResultParser;
import at.gridgears.held.internal.parser.ParseUtils;
import at.gridgears.held.internal.parser.ResponseParsingException;
import at.gridgears.held.internal.parser.SuccessResultParser;
import at.gridgears.schemas.held.AmlType;
import at.gridgears.schemas.held.ErrorType;
import at.gridgears.schemas.held.LocationResponseType;
import at.gridgears.schemas.held.LocationTypeType;
import java.io.StringReader;
import java.util.List;
import java.util.Optional;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

public class ResponseParser {
    private final Jaxb2Marshaller jaxb2Marshaller = new Jaxb2Marshaller();
    private final SuccessResultParser successResultParser;
    private final ErrorResultParser errorResultParser;

    public ResponseParser(String language) {
        this.jaxb2Marshaller.setSupportJaxbElementClass(true);
        this.jaxb2Marshaller.setCheckForXmlRootElement(false);
        this.jaxb2Marshaller.setClassesToBeBound(new Class[]{LocationResponseType.class, LocationTypeType.class, ErrorType.class, AmlType.class});
        this.successResultParser = new SuccessResultParser();
        this.errorResultParser = new ErrorResultParser(language);
    }

    public FindLocationResult parse(String responseContent) throws ResponseParsingException {
        Object unmarshalled = this.unmarshall(responseContent);
        Optional<LocationResponseType> locationResponseTypeOptional = ParseUtils.getValue(unmarshalled, LocationResponseType.class);
        if (locationResponseTypeOptional.isPresent()) {
            Pair<List<Location>, List<LocationReference>> parseResult = this.successResultParser.parse(locationResponseTypeOptional.get());
            return FindLocationResult.createFoundResult((List)parseResult.getLeft(), (List)parseResult.getRight());
        }
        Optional<ErrorType> errorTypeOptional = ParseUtils.getValue(unmarshalled, ErrorType.class);
        if (errorTypeOptional.isPresent()) {
            return FindLocationResult.createFailureResult(this.errorResultParser.parse(errorTypeOptional.get()));
        }
        throw new ResponseParsingException("Could not parse HELD response. Invalid content");
    }

    private Object unmarshall(String responseContent) throws ResponseParsingException {
        try {
            return this.jaxb2Marshaller.unmarshal((Source)new StreamSource(new StringReader(responseContent)));
        }
        catch (Exception e) {
            throw new ResponseParsingException("Could not unmarshall responseContent", e);
        }
    }
}

