/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.lucre.matrix.gui.impl;

import de.sciss.lucre.matrix.DataSource;
import de.sciss.lucre.matrix.Matrix;
import de.sciss.lucre.matrix.gui.DimensionIndex;
import de.sciss.lucre.matrix.gui.impl.DimensionIndexImpl;
import de.sciss.lucre.stm.Sys;
import de.sciss.lucre.stm.Txn;
import java.io.IOException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;

public final class DimensionIndexImpl$ {
    public static DimensionIndexImpl$ MODULE$;

    static {
        new DimensionIndexImpl$();
    }

    public <S extends Sys<S>> DimensionIndex<S> apply(Matrix<S> dim, Txn tx, DataSource.Resolver<S> resolver, ExecutionContext exec) {
        Boolean bl;
        if (dim.rank(tx) != 1) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Matrix must be 1-dimensional"})).s((Seq)Nil$.MODULE$));
        }
        int sz = (int)dim.size(tx);
        Matrix.Key key = dim.getKey(0, tx);
        Promise p = Promise$.MODULE$.apply();
        float[] arr = new float[sz];
        Future fut = p.future();
        try {
            Matrix.Reader r = key.reader(tx, resolver);
            Predef$.MODULE$.assert(r.numChannels() == 1 && r.numFrames() == (long)sz);
            tx.afterCommit((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Future fut1 = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    float[][] buf = (float[][])((Object[])new float[][]{arr});
                    r.read(buf, 0, sz);
                }), exec);
                p.completeWith(fut1);
            });
            bl = BoxedUnit.UNIT;
        }
        catch (IOException e) {
            bl = BoxesRunTime.boxToBoolean((boolean)p.tryFailure((Throwable)e));
        }
        Function1<Object, String> unitsFun = this.unitsStringFormatter(dim.units(tx));
        DimensionIndexImpl.Impl res = new DimensionIndexImpl.Impl(arr, (Future<BoxedUnit>)fut, unitsFun);
        fut.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            de.sciss.lucre.swing.package$.MODULE$.defer((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> res.fireReady());
            return BoxedUnit.UNIT;
        }, exec);
        return res;
    }

    public boolean shouldUseUnitsString(String units) {
        return units.startsWith("days since") || units.startsWith("hours since") || units.startsWith("seconds since");
    }

    public String mkUnitsString(String units) {
        String string = units;
        String string2 = "degrees_north".equals(string) ? "\u00b0N" : ("degrees_east".equals(string) ? "\u00b0E" : ("kg m-2 s-1".equals(string) ? "kg/(m\u00b2s)" : ("W m-2".equals(string) ? "W/m\u00b2" : ("m s-1".equals(string) ? "m/s" : units))));
        return string2;
    }

    public Function1<Object, String> unitsStringFormatter(String units) {
        Function1 & Serializable & scala.Serializable intersect;
        String string = units;
        if ("".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$1(BoxesRunTime.unboxToDouble((Object)d));
        } else if ("degrees_north".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$2(BoxesRunTime.unboxToDouble((Object)d));
        } else if ("degrees_east".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$3(BoxesRunTime.unboxToDouble((Object)d));
        } else if ("(0 - 1)".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$4(BoxesRunTime.unboxToDouble((Object)d));
        } else if ("kg m-2 s-1".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$5(BoxesRunTime.unboxToDouble((Object)d));
        } else if ("W m-2".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$6(BoxesRunTime.unboxToDouble((Object)d));
        } else if ("m s-1".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$7(BoxesRunTime.unboxToDouble((Object)d));
        } else if ("Pa".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$8(BoxesRunTime.unboxToDouble((Object)d));
        } else if (units.startsWith("days since")) {
            CalendarDate date = CalendarDateFormatter.isoStringToCalendarDate(null, (String)units.substring(11));
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$9(date, BoxesRunTime.unboxToDouble((Object)d));
        } else if (units.startsWith("hours since")) {
            CalendarDate date = CalendarDateFormatter.isoStringToCalendarDate(null, (String)units.substring(12));
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$10(date, BoxesRunTime.unboxToDouble((Object)d));
        } else if (units.startsWith("seconds since")) {
            CalendarDate date = CalendarDateFormatter.isoStringToCalendarDate(null, (String)units.substring(14));
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$11(date, BoxesRunTime.unboxToDouble((Object)d));
        } else {
            intersect = (Function1 & Serializable & scala.Serializable)d -> DimensionIndexImpl$.$anonfun$unitsStringFormatter$12(units, BoxesRunTime.unboxToDouble((Object)d));
        }
        return intersect;
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$1(double d) {
        double arg$macro$1 = d;
        return new StringOps("%1.2f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$2(double d) {
        String string;
        if (d >= 0.0) {
            double arg$macro$2 = d;
            string = new StringOps("%1.2f \u00b0N").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$2)}));
        } else {
            double arg$macro$3 = -d;
            string = new StringOps("%1.2f \u00b0S").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}));
        }
        return string;
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$3(double d) {
        String string;
        if (d >= 0.0) {
            double arg$macro$4 = d;
            string = new StringOps("%1.2f \u00b0E").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$4)}));
        } else {
            double arg$macro$5 = -d;
            string = new StringOps("%1.2f \u00b0W").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$5)}));
        }
        return string;
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$4(double d) {
        double arg$macro$6 = d * (double)100;
        return new StringOps("%1.1f%%").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$6)}));
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$5(double d) {
        double arg$macro$7 = d;
        return new StringOps("%1.2f kg/(m\u00b2s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$7)}));
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$6(double d) {
        double arg$macro$8 = d;
        return new StringOps("%1.2f W/m\u00b2").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$8)}));
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$7(double d) {
        double arg$macro$9 = d;
        return new StringOps("%1.2f m/s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$9)}));
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$8(double d) {
        int arg$macro$10 = (int)d;
        return new StringOps("%d Pa").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$10)}));
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$9(CalendarDate date$1, double d) {
        CalendarDate dt = date$1.add(d, CalendarPeriod.Field.Day);
        return CalendarDateFormatter.toDateTimeString((CalendarDate)dt);
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$10(CalendarDate date$2, double d) {
        CalendarDate dt = date$2.add(d, CalendarPeriod.Field.Hour);
        return CalendarDateFormatter.toDateTimeString((CalendarDate)dt);
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$11(CalendarDate date$3, double d) {
        CalendarDate dt = date$3.add(d, CalendarPeriod.Field.Second);
        return CalendarDateFormatter.toDateTimeString((CalendarDate)dt);
    }

    public static final /* synthetic */ String $anonfun$unitsStringFormatter$12(String units$1, double d) {
        double arg$macro$11 = d;
        String arg$macro$12 = units$1;
        return new StringOps("%1.2f %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$11), arg$macro$12}));
    }

    private DimensionIndexImpl$() {
        MODULE$ = this;
    }
}

