/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.servlet;

import at.ipsquare.commons.servlet.RequestMatcher;
import at.ipsquare.commons.servlet.TrivialRequestMatcher;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PathPatternRequestMatcher
implements RequestMatcher {
    private static final Logger log = LoggerFactory.getLogger(PathPatternRequestMatcher.class);
    private final Pattern includePattern;
    private final Pattern excludePattern;

    public static RequestMatcher fromFilterConfig(FilterConfig config) {
        String inc = config.getInitParameter("includePathPattern");
        String exc = config.getInitParameter("excludePathPattern");
        if (inc == null) {
            inc = config.getServletContext().getInitParameter("includePathPattern");
        }
        if (exc == null) {
            exc = config.getServletContext().getInitParameter("excludePathPattern");
        }
        if (inc == null && exc == null) {
            return TrivialRequestMatcher.ANYTHING;
        }
        return new PathPatternRequestMatcher(inc, exc);
    }

    public PathPatternRequestMatcher(String includePattern, String excludePattern) {
        this(PathPatternRequestMatcher.compilePattern(includePattern), PathPatternRequestMatcher.compilePattern(excludePattern));
    }

    public PathPatternRequestMatcher(Pattern includePattern, Pattern excludePattern) {
        this.includePattern = includePattern;
        this.excludePattern = excludePattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matches(ServletRequest req) {
        boolean bl;
        String path;
        Boolean ret;
        block15: {
            block13: {
                boolean bl2;
                block14: {
                    block11: {
                        boolean bl3;
                        block12: {
                            if (!(req instanceof HttpServletRequest)) {
                                return false;
                            }
                            if (this.includePattern == null && this.excludePattern == null) {
                                return true;
                            }
                            ret = null;
                            path = PathPatternRequestMatcher.exctractPath((HttpServletRequest)req);
                            try {
                                if (this.includePattern == null || this.includePattern.matcher(path).matches()) break block11;
                                ret = false;
                                bl3 = ret;
                                if (ret != null) break block12;
                            }
                            catch (Throwable throwable) {
                                if (ret == null) {
                                    throw new AssertionError((Object)"Implementation error: ret not set, please fix!");
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug(this + " " + (ret != false ? "matched" : "rejected") + " path '" + path + "'.");
                                }
                                throw throwable;
                            }
                            throw new AssertionError((Object)"Implementation error: ret not set, please fix!");
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(this + " " + (ret != false ? "matched" : "rejected") + " path '" + path + "'.");
                        }
                        return bl3;
                    }
                    if (this.excludePattern == null || !this.excludePattern.matcher(path).matches()) break block13;
                    ret = false;
                    bl2 = ret;
                    if (ret != null) break block14;
                    throw new AssertionError((Object)"Implementation error: ret not set, please fix!");
                }
                if (log.isDebugEnabled()) {
                    log.debug(this + " " + (ret != false ? "matched" : "rejected") + " path '" + path + "'.");
                }
                return bl2;
            }
            ret = true;
            bl = ret;
            if (ret != null) break block15;
            throw new AssertionError((Object)"Implementation error: ret not set, please fix!");
        }
        if (log.isDebugEnabled()) {
            log.debug(this + " " + (ret != false ? "matched" : "rejected") + " path '" + path + "'.");
        }
        return bl;
    }

    private static String exctractPath(HttpServletRequest req) {
        return req.getServletPath().concat(StringUtils.defaultString((String)req.getPathInfo()));
    }

    private static Pattern compilePattern(String pattern) {
        return pattern != null ? Pattern.compile(pattern) : null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + PathPatternRequestMatcher.patternString(this.includePattern) + ", " + PathPatternRequestMatcher.patternString(this.excludePattern) + "]";
    }

    private static String patternString(Pattern pattern) {
        if (pattern == null) {
            return "null";
        }
        return "'" + pattern + "'";
    }
}

