/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.action.impl;

import at.molindo.esi4j.action.MultiSearchItemResponseWrapper;
import at.molindo.esi4j.action.MultiSearchResponseWrapper;
import at.molindo.esi4j.action.SearchHitWrapper;
import at.molindo.esi4j.action.impl.DefaultMultiSearchItemResponseWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.MultiSearchResponse;

public class DefaultMultiSearchResponseWrapper
implements MultiSearchResponseWrapper {
    private final MultiSearchResponse _response;
    private final SearchHitWrapper.SearchHitReader _reader;
    private List<MultiSearchItemResponseWrapper> _objects;

    public DefaultMultiSearchResponseWrapper(MultiSearchResponse response, SearchHitWrapper.SearchHitReader reader) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        this._response = response;
        this._reader = reader;
    }

    @Override
    public synchronized List<MultiSearchItemResponseWrapper> getMultiSearchItemResponses() {
        if (this._objects == null) {
            MultiSearchResponse.Item[] reps = this._response.getResponses();
            this._objects = Lists.newArrayListWithCapacity((int)reps.length);
            for (int i = 0; i < reps.length; ++i) {
                this._objects.add(new DefaultMultiSearchItemResponseWrapper(reps[i], this._reader));
            }
        }
        return this._objects;
    }

    @Override
    public MultiSearchResponse getMultiSearchResponse() {
        return this._response;
    }

    @Override
    public List<?> getObjects() {
        return this.getObjects(Object.class);
    }

    @Override
    public <T> List<T> getObjects(Class<T> type) {
        List<MultiSearchItemResponseWrapper> resps = this.getMultiSearchItemResponses();
        int size = 0;
        for (MultiSearchItemResponseWrapper response : resps) {
            size += response.getSearchHits().size();
        }
        ArrayList objects = Lists.newArrayListWithCapacity((int)size);
        for (MultiSearchItemResponseWrapper response : resps) {
            objects.addAll(response.getObjects(type));
        }
        return objects;
    }

    @Override
    public List<SearchHitWrapper> getSearchHits() {
        List<MultiSearchItemResponseWrapper> resps = this.getMultiSearchItemResponses();
        int size = 0;
        for (MultiSearchItemResponseWrapper response : resps) {
            size += response.getSearchHits().size();
        }
        ArrayList searchHits = Lists.newArrayListWithCapacity((int)size);
        for (MultiSearchItemResponseWrapper response : resps) {
            searchHits.addAll(response.getSearchHits());
        }
        return searchHits;
    }
}

