/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.action.impl;

import at.molindo.esi4j.action.SearchHitWrapper;
import at.molindo.esi4j.action.SearchResponseWrapper;
import at.molindo.esi4j.action.impl.DefaultSearchHitWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;

public class DefaultSearchResponseWrapper
implements SearchResponseWrapper {
    private final SearchResponse _response;
    private final SearchHitWrapper.SearchHitReader _reader;
    private List<SearchHitWrapper> _objects;

    public DefaultSearchResponseWrapper(SearchResponse response, SearchHitWrapper.SearchHitReader reader) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        this._response = response;
        this._reader = reader;
    }

    @Override
    public synchronized List<SearchHitWrapper> getSearchHits() {
        if (this._objects == null) {
            SearchHit[] hits = this._response.getHits().hits();
            this._objects = Lists.newArrayListWithCapacity((int)hits.length);
            for (int i = 0; i < hits.length; ++i) {
                this._objects.add(new DefaultSearchHitWrapper(hits[i], this._reader));
            }
        }
        return this._objects;
    }

    @Override
    public SearchResponse getSearchResponse() {
        return this._response;
    }

    @Override
    public List<?> getObjects() {
        return this.getObjects(Object.class);
    }

    @Override
    public <T> List<T> getObjects(Class<T> type) {
        List<SearchHitWrapper> hits = this.getSearchHits();
        ArrayList objects = Lists.newArrayListWithCapacity((int)hits.size());
        for (SearchHitWrapper hit : hits) {
            objects.add(hit.getObject(type));
        }
        return objects;
    }

    @Override
    public long getTotalHits() {
        return this.getSearchResponse().getHits().getTotalHits();
    }
}

