/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.chain.impl;

import at.molindo.esi4j.chain.Esi4JBatchedEventProcessor;
import at.molindo.esi4j.chain.Esi4JEntityTask;
import at.molindo.esi4j.chain.Esi4JTaskProcessor;
import at.molindo.esi4j.chain.Esi4JTaskSource;
import at.molindo.esi4j.chain.impl.AbstractEventListener;
import at.molindo.esi4j.chain.impl.DefaultEventProcessor;
import at.molindo.utils.collections.ArrayUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;

public class DefaultBatchedEventProcessor
extends DefaultEventProcessor
implements Esi4JBatchedEventProcessor {
    public DefaultBatchedEventProcessor(Esi4JTaskProcessor taskProcessor) {
        super(taskProcessor);
    }

    public DefaultBatchedEventProcessor(Esi4JTaskProcessor taskProcessor, Map<Class<?>, Esi4JTaskSource> taskSources) {
        super(taskProcessor, taskSources);
    }

    @Override
    public Esi4JBatchedEventProcessor.EventSession startSession() {
        return new SimpleEventSession();
    }

    public class SimpleEventSession
    extends AbstractEventListener
    implements Esi4JBatchedEventProcessor.EventSession {
        private List<Esi4JEntityTask[]> _tasks = Lists.newArrayList();
        private int _taskCount = 0;

        @Override
        public void onPostInsert(Object o) {
            this.addTasks(DefaultBatchedEventProcessor.this.getPostInsertTasks(o));
        }

        @Override
        public void onPostUpdate(Object o) {
            this.addTasks(DefaultBatchedEventProcessor.this.getPostUpdateTasks(o));
        }

        @Override
        public void onPostDelete(Object o) {
            this.addTasks(DefaultBatchedEventProcessor.this.getPostDeleteTasks(o));
        }

        private void addTasks(Esi4JEntityTask[] tasks) {
            if (!ArrayUtils.empty((Object[])tasks)) {
                this._tasks.add(tasks);
                this._taskCount += tasks.length;
            }
        }

        @Override
        public void flush() {
            Esi4JEntityTask[] allTasks = new Esi4JEntityTask[this._taskCount];
            int from = 0;
            for (Esi4JEntityTask[] tasks : this._tasks) {
                System.arraycopy(tasks, 0, allTasks, from, tasks.length);
                from += tasks.length;
            }
            this._tasks.clear();
            this._taskCount = 0;
            DefaultBatchedEventProcessor.this.processTasks(allTasks);
        }
    }
}

