/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.chain.impl;

import at.molindo.esi4j.chain.Esi4JEntityTask;
import at.molindo.esi4j.chain.Esi4JEventProcessor;
import at.molindo.esi4j.chain.Esi4JTaskProcessor;
import at.molindo.esi4j.chain.Esi4JTaskSource;
import at.molindo.esi4j.chain.impl.AbstractEventListener;
import at.molindo.utils.collections.ArrayUtils;
import at.molindo.utils.collections.ClassMap;
import at.molindo.utils.collections.CollectionUtils;
import java.util.Map;

public class DefaultEventProcessor
extends AbstractEventListener
implements Esi4JEventProcessor {
    private volatile ClassMap<Esi4JTaskSource> _taskSources;
    private final Esi4JTaskProcessor _taskProcessor;

    public DefaultEventProcessor(Esi4JTaskProcessor taskProcessor) {
        this(taskProcessor, null);
    }

    public DefaultEventProcessor(Esi4JTaskProcessor taskProcessor, Map<Class<?>, Esi4JTaskSource> taskSources) {
        if (taskProcessor == null) {
            throw new NullPointerException("taskProcessor");
        }
        this._taskProcessor = taskProcessor;
        this._taskSources = new ClassMap();
        if (!CollectionUtils.empty(taskSources)) {
            this._taskSources.putAll(taskSources);
        }
    }

    @Override
    public boolean isProcessing(Class<?> type) {
        return this._taskSources.find(type) != null;
    }

    @Override
    public void putTaskSource(Class<?> type, Esi4JTaskSource taskSource) {
        ClassMap<Esi4JTaskSource> temp = this.copyTaskSources();
        temp.put(type, (Object)taskSource);
        this._taskSources = temp;
    }

    @Override
    public void removeTaskSource(Class<?> type) {
        ClassMap<Esi4JTaskSource> temp = this.copyTaskSources();
        temp.remove(type);
        this._taskSources = temp;
    }

    ClassMap<Esi4JTaskSource> copyTaskSources() {
        return new ClassMap(this._taskSources);
    }

    protected void processTasks(Esi4JEntityTask[] tasks) {
        if (!ArrayUtils.empty((Object[])tasks)) {
            this._taskProcessor.processTasks(tasks);
        }
    }

    protected Esi4JTaskSource findTaskSource(Object o) {
        return o == null ? null : (Esi4JTaskSource)this._taskSources.find(o.getClass());
    }

    @Override
    public void onPostInsert(Object o) {
        this.processTasks(this.getPostInsertTasks(o));
    }

    @Override
    public void onPostUpdate(Object o) {
        this.processTasks(this.getPostUpdateTasks(o));
    }

    @Override
    public void onPostDelete(Object o) {
        this.processTasks(this.getPostDeleteTasks(o));
    }

    protected Esi4JEntityTask[] getPostInsertTasks(Object o) {
        Esi4JTaskSource src = this.findTaskSource(o);
        return src == null ? null : src.getPostInsertTasks(o);
    }

    protected Esi4JEntityTask[] getPostUpdateTasks(Object o) {
        Esi4JTaskSource src = this.findTaskSource(o);
        return src == null ? null : src.getPostUpdateTasks(o);
    }

    protected Esi4JEntityTask[] getPostDeleteTasks(Object o) {
        Esi4JTaskSource src = this.findTaskSource(o);
        return src == null ? null : src.getPostDeleteTasks(o);
    }

    @Override
    public Esi4JTaskProcessor getTaskProcessor() {
        return this._taskProcessor;
    }

    @Override
    public void close() {
    }
}

