/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.chain.impl;

import at.molindo.esi4j.action.BulkResponseWrapper;
import at.molindo.esi4j.chain.Esi4JEntityTask;
import at.molindo.esi4j.chain.Esi4JTaskProcessor;
import at.molindo.esi4j.chain.impl.AbstractTaskProcessor;
import at.molindo.esi4j.chain.impl.SerializableEsi4JOperation;
import at.molindo.esi4j.core.Esi4JIndex;
import at.molindo.esi4j.core.Esi4JOperation;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskProcessor
extends AbstractTaskProcessor
implements Esi4JTaskProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskProcessor.class);
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();

    public DefaultTaskProcessor(Esi4JIndex index) {
        super(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processTasks(final Esi4JEntityTask[] tasks) {
        this._lock.readLock().lock();
        try {
            BulkResponseWrapper response = (BulkResponseWrapper)this.getIndex().executeBulk(new Esi4JOperation<ListenableActionFuture<BulkResponse>>(){

                @Override
                public ListenableActionFuture<BulkResponse> execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
                    BulkRequestBuilder bulk = client.prepareBulk();
                    for (int i = 0; i < tasks.length; ++i) {
                        tasks[i].addToBulk(bulk, indexName, helper);
                    }
                    return bulk.execute();
                }
            }).actionGet();
            if (log.isDebugEnabled()) {
                log.debug("finished bulk indexing " + response.getBulkResponse().getItems().length + " items");
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(SerializableEsi4JOperation<T> operation) {
        this._lock.writeLock().lock();
        try {
            T value = this.getIndex().execute(operation);
            if (log.isDebugEnabled()) {
                log.debug("finished submitted operation");
            }
            T t = value;
            return t;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }
}

