/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.chain.impl;

import at.molindo.esi4j.chain.Esi4JEntityResolver;
import at.molindo.esi4j.chain.Esi4JEntityTask;
import at.molindo.esi4j.chain.impl.AbstractEntityTask;
import at.molindo.esi4j.core.Esi4JOperation;
import at.molindo.esi4j.mapping.TypeMapping;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;

public final class IndexEntityTask
extends AbstractEntityTask {
    private static final long serialVersionUID = 1L;

    public IndexEntityTask(Object entity) {
        super(entity);
    }

    @Override
    protected void initClone(Esi4JEntityTask clone) {
    }

    @Override
    public void replaceEntity(Esi4JEntityResolver entityResolver) {
        this.setEntity(entityResolver.replaceEntity(this.getEntity()));
    }

    @Override
    public void resolveEntity(Esi4JEntityResolver entityResolver) {
        this.setEntity(entityResolver.resolveEntity(this.getEntity()));
    }

    @Override
    public void addToBulk(BulkRequestBuilder bulk, String indexName, Esi4JOperation.OperationContext context) {
        Object entity = this.getEntity();
        if (entity != null) {
            TypeMapping mapping = context.findTypeMapping(entity);
            IndexRequest index = mapping.indexRequest(indexName, entity);
            if (index != null) {
                bulk.add(index);
            } else {
                DeleteRequest delete = mapping.deleteRequest(indexName, entity);
                if (delete != null) {
                    bulk.add(delete);
                }
            }
        }
    }
}

