/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.core.impl;

import at.molindo.esi4j.action.CountResponseWrapper;
import at.molindo.esi4j.action.MultiGetItemResponseWrapper;
import at.molindo.esi4j.action.MultiGetResponseWrapper;
import at.molindo.esi4j.action.MultiSearchResponseWrapper;
import at.molindo.esi4j.action.SearchHitWrapper;
import at.molindo.esi4j.action.SearchResponseWrapper;
import at.molindo.esi4j.action.impl.DefaultCountResponseWrapper;
import at.molindo.esi4j.action.impl.DefaultMultiGetResponseWrapper;
import at.molindo.esi4j.action.impl.DefaultMultiSearchResponseWrapper;
import at.molindo.esi4j.action.impl.DefaultSearchResponseWrapper;
import at.molindo.esi4j.core.Esi4JManagedIndex;
import at.molindo.esi4j.core.Esi4JOperation;
import at.molindo.esi4j.core.Esi4JSearchIndex;
import at.molindo.esi4j.core.Esi4JStore;
import at.molindo.esi4j.mapping.TypeMapping;
import at.molindo.esi4j.util.ListenableActionFutureWrapper;
import at.molindo.utils.data.Function;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.count.CountRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;

public abstract class AbstractIndex
implements Esi4JSearchIndex,
Esi4JManagedIndex,
Esi4JOperation.OperationContext,
SearchHitWrapper.SearchHitReader,
MultiGetItemResponseWrapper.MultiGetItemReader {
    @Override
    public <T> T execute(final Esi4JOperation<T> operation) {
        return this.getStore().execute(new Esi4JStore.StoreOperation<T>(){

            @Override
            public T execute(Client client, String indexName) {
                return operation.execute(client, indexName, AbstractIndex.this);
            }
        });
    }

    @Override
    public ListenableActionFuture<SearchResponseWrapper> search(QueryBuilder query, Class<?> type) {
        return this.executeSearch(new Search(query, type));
    }

    @Override
    public ListenableActionFuture<SearchResponseWrapper> search(QueryBuilder query, Class<?> type, int from, int size) {
        return this.executeSearch(new Search(query, type, from, size));
    }

    @Override
    public ListenableActionFuture<SearchResponseWrapper> executeSearch(Esi4JOperation<ListenableActionFuture<SearchResponse>> searchOperation) {
        return ListenableActionFutureWrapper.wrap(this.execute(searchOperation), new Function<SearchResponse, SearchResponseWrapper>(){

            public SearchResponseWrapper apply(SearchResponse response) {
                return new DefaultSearchResponseWrapper(response, AbstractIndex.this);
            }
        });
    }

    @Override
    public ListenableActionFuture<MultiSearchResponseWrapper> executeMultiSearch(Esi4JOperation<ListenableActionFuture<MultiSearchResponse>> multiSearchOperation) {
        return ListenableActionFutureWrapper.wrap(this.execute(multiSearchOperation), new Function<MultiSearchResponse, MultiSearchResponseWrapper>(){

            public MultiSearchResponseWrapper apply(MultiSearchResponse response) {
                return new DefaultMultiSearchResponseWrapper(response, AbstractIndex.this);
            }
        });
    }

    @Override
    public ListenableActionFuture<CountResponseWrapper> count(QueryBuilder query, Class<?> type) {
        return this.executeCount(new Count(query, type));
    }

    @Override
    public ListenableActionFuture<CountResponseWrapper> executeCount(Esi4JOperation<ListenableActionFuture<CountResponse>> countOperation) {
        return ListenableActionFutureWrapper.wrap(this.execute(countOperation), new Function<CountResponse, CountResponseWrapper>(){

            public CountResponseWrapper apply(CountResponse response) {
                return new DefaultCountResponseWrapper(response);
            }
        });
    }

    @Override
    public ListenableActionFuture<MultiGetResponseWrapper> multiGet(Class<?> type, Iterable<?> ids) {
        return this.executeMultiGet(new MultiGet(type, ids));
    }

    @Override
    public ListenableActionFuture<MultiGetResponseWrapper> executeMultiGet(Esi4JOperation<ListenableActionFuture<MultiGetResponse>> multiGetOperation) {
        return ListenableActionFutureWrapper.wrap(this.execute(multiGetOperation), new Function<MultiGetResponse, MultiGetResponseWrapper>(){

            public MultiGetResponseWrapper apply(MultiGetResponse input) {
                return new DefaultMultiGetResponseWrapper(input, AbstractIndex.this);
            }
        });
    }

    @Override
    public final Object read(SearchHit hit) {
        return this.findTypeMapping(hit.index(), hit.type()).read(hit);
    }

    @Override
    public Object read(MultiGetItemResponse response) {
        return this.findTypeMapping(response.getIndex(), response.getType()).read(response.getResponse());
    }

    protected abstract Esi4JStore getStore();

    private static final class MultiGet
    implements Esi4JOperation<ListenableActionFuture<MultiGetResponse>> {
        private final Class<?> _type;
        private final Iterable<?> _ids;

        private MultiGet(Class<?> type, Iterable<?> ids) {
            if (type == null) {
                throw new NullPointerException("type");
            }
            if (ids == null) {
                throw new NullPointerException("ids");
            }
            this._type = type;
            this._ids = ids;
        }

        @Override
        public ListenableActionFuture<MultiGetResponse> execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
            TypeMapping typeMapping = helper.findTypeMapping(this._type);
            String type = typeMapping.getTypeAlias();
            MultiGetRequestBuilder builder = client.prepareMultiGet();
            for (Object id : this._ids) {
                builder.add(helper.findIndexName(this._type), type, typeMapping.toIdString(id));
            }
            return builder.execute();
        }
    }

    protected static final class Count
    implements Esi4JOperation<ListenableActionFuture<CountResponse>> {
        private final QueryBuilder _query;
        private final Class<?> _type;

        private Count(QueryBuilder query, Class<?> type) {
            if (type == null) {
                throw new NullPointerException("type");
            }
            if (query == null) {
                throw new NullPointerException("query");
            }
            this._query = query;
            this._type = type;
        }

        @Override
        public ListenableActionFuture<CountResponse> execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
            TypeMapping typeMapping = helper.findTypeMapping(this._type);
            String type = typeMapping.getTypeAlias();
            CountRequestBuilder builder = client.prepareCount(new String[]{indexName}).setTypes(new String[]{type}).setQuery(this._query);
            return builder.execute();
        }
    }

    protected static final class Search
    implements Esi4JOperation<ListenableActionFuture<SearchResponse>> {
        private final QueryBuilder _query;
        private final Class<?> _type;
        private final int _from;
        private final int _size;

        private Search(QueryBuilder query, Class<?> type) {
            this(query, type, 0, 10);
        }

        private Search(QueryBuilder query, Class<?> type, int from, int size) {
            if (type == null) {
                throw new NullPointerException("type");
            }
            if (query == null) {
                throw new NullPointerException("query");
            }
            this._query = query;
            this._type = type;
            this._from = from;
            this._size = size;
        }

        @Override
        public ListenableActionFuture<SearchResponse> execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
            TypeMapping typeMapping = helper.findTypeMapping(this._type);
            String type = typeMapping.getTypeAlias();
            SearchRequestBuilder builder = client.prepareSearch(new String[]{indexName}).setTypes(new String[]{type}).setQuery(this._query).setFrom(this._from).setSize(this._size);
            return builder.execute();
        }
    }
}

