/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.core.impl;

import at.molindo.esi4j.chain.Esi4JProcessingChain;
import at.molindo.esi4j.chain.impl.DefaultTaskSource;
import at.molindo.esi4j.core.Esi4JIndex;
import at.molindo.esi4j.core.Esi4JIndexManager;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.module.Esi4JModule;
import at.molindo.esi4j.operation.RefreshOperation;
import at.molindo.esi4j.rebuild.Esi4JRebuildManager;
import at.molindo.esi4j.rebuild.impl.DefaultRebuildManager;
import at.molindo.utils.collections.ArrayUtils;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;

public class AbstractIndexManager
implements Esi4JIndexManager {
    private final InternalIndex _index;
    private final Esi4JModule _module;
    private final Class<?>[] _types;
    private final Esi4JProcessingChain _processingChain;
    private final Esi4JRebuildManager _rebuildManager;

    public AbstractIndexManager(Esi4JModule module, InternalIndex index, Esi4JProcessingChain processingChain) {
        this(module, index, processingChain, new DefaultRebuildManager());
    }

    public AbstractIndexManager(Esi4JModule module, InternalIndex index, Esi4JProcessingChain processingChain, Esi4JRebuildManager rebuildManager) {
        if (index == null) {
            throw new NullPointerException("index");
        }
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (processingChain == null) {
            throw new NullPointerException("processingChain");
        }
        if (rebuildManager == null) {
            throw new NullPointerException("rebuildManager");
        }
        this._index = index;
        this._module = module;
        this._processingChain = processingChain;
        this._rebuildManager = rebuildManager;
        HashSet types = Sets.newHashSet((Object[])this._module.getTypes());
        types.retainAll(Arrays.asList(this._index.getMappedTypes()));
        for (Class<?> type : this._types = types.toArray(new Class[types.size()])) {
            if (processingChain.getEventProcessor().isProcessing(type)) continue;
            processingChain.getEventProcessor().putTaskSource(type, new DefaultTaskSource());
        }
    }

    @Override
    public Esi4JIndex getIndex() {
        return this._index;
    }

    @Override
    public void rebuild(Class<?> ... types) {
        if (ArrayUtils.empty((Object[])types)) {
            types = new Class[this._types.length];
            System.arraycopy(this._types, 0, types, 0, this._types.length);
        } else if (!Arrays.asList(this._types).containsAll(Arrays.asList(types))) {
            HashSet set = Sets.newHashSet((Object[])types);
            set.removeAll(Arrays.asList(this._types));
            throw new IllegalArgumentException("can't rebuild unmanaged types: " + set);
        }
        this._rebuildManager.rebuild(this._module, this._index, types);
    }

    @Override
    public void refresh() {
        this._processingChain.getTaksProcessor().execute(new RefreshOperation());
    }

    @Override
    public final void close() {
        this.onBeforeClose();
        this._module.close();
        this._processingChain.getEventProcessor().close();
        this._processingChain.getTaksProcessor().close();
        this._rebuildManager.close();
        this.onAfterClose();
    }

    protected void onBeforeClose() {
    }

    protected void onAfterClose() {
    }

    @Override
    public Class<?>[] getTypes() {
        Class[] types = new Class[this._types.length];
        System.arraycopy(this._types, 0, types, 0, this._types.length);
        return types;
    }

    protected Esi4JModule getModule() {
        return this._module;
    }

    protected Esi4JProcessingChain getProcessingChain() {
        return this._processingChain;
    }
}

