/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.core.impl;

import at.molindo.esi4j.core.Esi4J;
import at.molindo.esi4j.core.Esi4JClient;
import at.molindo.esi4j.core.Esi4JFactory;
import at.molindo.esi4j.core.Esi4JIndex;
import at.molindo.esi4j.core.Esi4JIndexManager;
import at.molindo.esi4j.core.Esi4JManagedIndex;
import at.molindo.esi4j.core.impl.DefaultIndex;
import at.molindo.esi4j.core.impl.DefaultStore;
import at.molindo.esi4j.core.impl.TransportClientFactory;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.multi.impl.DefaultManagedMultiIndex;
import at.molindo.esi4j.util.Esi4JUtils;
import at.molindo.utils.collections.CollectionUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.internal.InternalSettingsPreparer;

public class DefaultEsi4J
implements Esi4J {
    private final Settings _settings;
    private final Environment _environment;
    private final ConcurrentMap<String, Esi4JClient> _clients = Maps.newConcurrentMap();
    private final ConcurrentMap<String, InternalIndex> _indexes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, Esi4JIndexManager> _indexManagers = Maps.newConcurrentMap();

    public DefaultEsi4J() {
        this(ImmutableSettings.settingsBuilder().build(), true);
    }

    public DefaultEsi4J(Settings settings) {
        this(settings, true);
    }

    public DefaultEsi4J(Settings settings, boolean loadConfigSettings) {
        Tuple tuple = InternalSettingsPreparer.prepareSettings((Settings)settings, (boolean)loadConfigSettings);
        this._settings = ImmutableSettings.settingsBuilder().put((Settings)tuple.v1()).put("esi4j.enabled", true).build();
        this._environment = (Environment)tuple.v2();
        this.configure();
    }

    private void configure() {
        this.configureClients();
        this.configureIndexes();
    }

    private void configureClients() {
        String[] clients;
        for (String clientName : clients = this._settings.getAsArray("esi4j.clients", new String[]{"default"})) {
            Settings clientSettings = ImmutableSettings.settingsBuilder().put(this._settings).put(Esi4JUtils.getSettings(this._settings, "client." + clientName + ".", "esi4j.client.")).build();
            Class factoryClass = clientSettings.getAsClass("esi4j.client.type", TransportClientFactory.class, "at.molindo.esi4j.core.impl.", "ClientFactory");
            Esi4JFactory factory = (Esi4JFactory)Esi4JUtils.createObject(factoryClass, clientSettings);
            this._clients.put(clientName, (Esi4JClient)factory.create());
        }
    }

    private void configureIndexes() {
        String[] indexNames;
        for (String indexName : indexNames = this._settings.getAsArray("esi4j.indexes", new String[]{"default"})) {
            Settings indexSettings = ImmutableSettings.settingsBuilder().put(this._settings).put(Esi4JUtils.getSettings(this._settings, "index." + indexName + ".", "index.")).put(Esi4JUtils.getSettings(this._settings, "esi4j.index." + indexName + ".", "esi4j.index.")).build();
            String clientName = indexSettings.get("esi4j.index.client", "default");
            Esi4JClient client = (Esi4JClient)this._clients.get(clientName);
            if (client == null) {
                throw new NullPointerException("client");
            }
            this._indexes.put(indexName, new DefaultIndex(indexName, indexSettings, new DefaultStore(client, indexName)));
        }
    }

    @Override
    public InternalIndex getIndex() {
        return this.getIndex("default");
    }

    @Override
    public InternalIndex getIndex(String name) {
        InternalIndex index = (InternalIndex)this._indexes.get(name);
        if (index == null) {
            throw new IllegalStateException("index '" + name + "' not configured");
        }
        return index;
    }

    @Override
    public Esi4JIndex findIndex(Class<?> type) {
        return (Esi4JIndex)this.findMultiIndex(type);
    }

    @Override
    public Esi4JManagedIndex getMultiIndex(String ... names) {
        return this.getMultiIndex(Arrays.asList(names));
    }

    @Override
    public Esi4JManagedIndex getMultiIndex(List<String> names) {
        if (CollectionUtils.empty(names)) {
            return new DefaultManagedMultiIndex(this._indexes.values());
        }
        if (names.size() == 1) {
            String name = names.get(0);
            if ("*".equals(name)) {
                return new DefaultManagedMultiIndex(this._indexes.values());
            }
            return this.getIndex(name);
        }
        ArrayList indices = Lists.newArrayListWithCapacity((int)names.size());
        for (String name : names) {
            indices.add(this.getIndex(name));
        }
        return new DefaultManagedMultiIndex(indices);
    }

    @Override
    public Esi4JManagedIndex findMultiIndex(Class<?> ... types) {
        return this.findMultiIndex(Arrays.asList(types));
    }

    @Override
    public Esi4JManagedIndex findMultiIndex(List<Class<? extends Object>> types) {
        ArrayList names = Lists.newArrayListWithCapacity((int)this._indexes.size());
        block0: for (Map.Entry e : this._indexes.entrySet()) {
            for (Class<? extends Object> type : types) {
                if (!((InternalIndex)e.getValue()).isMapped(type)) continue;
                names.add(e.getKey());
                continue block0;
            }
        }
        return this.getMultiIndex(names);
    }

    @Override
    public void close() {
        for (Esi4JClient client : this._clients.values()) {
            client.close();
        }
    }

    @Override
    public void registerIndexManger(Esi4JIndexManager indexManager) {
        Esi4JManagedIndex index = indexManager.getIndex();
        String indexName = index.getName();
        if (this._indexManagers.putIfAbsent(indexName, indexManager) != null) {
            throw new IllegalStateException("already an index manager registered for index " + indexName);
        }
        index.setIndexManager(indexManager);
    }
}

