/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.core.impl;

import at.molindo.esi4j.action.BulkResponseWrapper;
import at.molindo.esi4j.action.DeleteResponseWrapper;
import at.molindo.esi4j.action.GetResponseWrapper;
import at.molindo.esi4j.action.IndexResponseWrapper;
import at.molindo.esi4j.action.impl.DefaultBulkResponseWrapper;
import at.molindo.esi4j.action.impl.DefaultDeleteResponseWrapper;
import at.molindo.esi4j.action.impl.DefaultGetResponseWrapper;
import at.molindo.esi4j.action.impl.DefaultIndexResponseWrapper;
import at.molindo.esi4j.core.Esi4JIndexManager;
import at.molindo.esi4j.core.Esi4JOperation;
import at.molindo.esi4j.core.Esi4JStore;
import at.molindo.esi4j.core.impl.AbstractIndex;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.ex.Esi4JObjectFilteredException;
import at.molindo.esi4j.mapping.TypeMapping;
import at.molindo.esi4j.mapping.TypeMappings;
import at.molindo.esi4j.util.ListenableActionFutureWrapper;
import at.molindo.utils.data.Function;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.annotation.Nonnull;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;

public class DefaultIndex
extends AbstractIndex
implements InternalIndex {
    private final String _name;
    private final Settings _settings;
    private final TypeMappings _mappings;
    private Esi4JIndexManager _indexManager;
    @Nonnull
    private Esi4JStore _store;

    public DefaultIndex(String name, Settings settings, Esi4JStore store) {
        if (name == null) {
            throw new NullPointerException("id");
        }
        this._name = name;
        this._settings = settings;
        this._mappings = new TypeMappings();
        this.setStore(store);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Settings getSettings() {
        return this._settings;
    }

    @Override
    public Esi4JStore getStore() {
        return this._store;
    }

    @Override
    public void setStore(Esi4JStore store) {
        if (store == null) {
            throw new NullPointerException("store");
        }
        store.setIndex(this);
        this._store = store;
        for (TypeMapping typeMapping : this._mappings.getTypeMappings()) {
            this.putMapping(typeMapping);
        }
    }

    @Override
    public void close() {
        if (this._indexManager != null) {
            this._indexManager.close();
        }
        this._store.close();
    }

    @Override
    public String findIndexName(Class<?> type) {
        if (!this.isMapped(type)) {
            throw new IllegalArgumentException("unmapped type " + type.getName() + " for index " + this.getName());
        }
        return this.getName();
    }

    @Override
    public TypeMapping findTypeMapping(Object o) {
        return this._mappings.findTypeMapping(o);
    }

    @Override
    public TypeMapping findTypeMapping(Class<?> type) {
        return this._mappings.findTypeMapping(type);
    }

    @Override
    public TypeMapping findTypeMapping(String indexName, String typeAlias) {
        if (!this.getStore().getIndexName().equals(indexName)) {
            throw new IllegalArgumentException("unexpected indexName, was " + indexName + ", expected " + this.getStore().getIndexName());
        }
        return this._mappings.findTypeMapping(typeAlias);
    }

    @Override
    public DefaultIndex addTypeMapping(TypeMapping typeMapping) {
        this._mappings.addMapping(typeMapping);
        this.putMapping(typeMapping);
        return this;
    }

    @Override
    public void updateMapping(Class<?> type) {
        this.putMapping(this._mappings.findTypeMapping(type));
    }

    @Override
    public boolean isMapped(Class<?> type) {
        return this._mappings.getTypeMapping(type) != null;
    }

    @Override
    public boolean isMapped(Object o) {
        return this._mappings.getTypeMapping(o) != null;
    }

    @Override
    public void updateMapping(String typeAlias) {
        this.putMapping(this._mappings.findTypeMapping(typeAlias));
    }

    @Override
    public Class<?>[] getMappedTypes() {
        return this._mappings.getMappedTypes();
    }

    protected void putMapping(final TypeMapping typeMapping) {
        ListenableActionFuture<PutMappingResponse> future = this._store.execute(new Esi4JStore.StoreOperation<ListenableActionFuture<PutMappingResponse>>(){

            @Override
            public ListenableActionFuture<PutMappingResponse> execute(Client client, String indexName) {
                PutMappingRequestBuilder request = client.admin().indices().preparePutMapping(new String[]{indexName});
                request.setType(typeMapping.getTypeAlias());
                typeMapping.getMappingSource().setSource(request);
                return request.execute();
            }
        });
        future.actionGet();
    }

    @Override
    public ListenableActionFuture<IndexResponseWrapper> index(Object o) {
        return this.executeIndex(new Index(o));
    }

    @Override
    public ListenableActionFuture<IndexResponseWrapper> executeIndex(Esi4JOperation<ListenableActionFuture<IndexResponse>> indexOperation) {
        return ListenableActionFutureWrapper.wrap(this.execute(indexOperation), new Function<IndexResponse, IndexResponseWrapper>(){

            public IndexResponseWrapper apply(IndexResponse input) {
                TypeMapping typeMapping = DefaultIndex.this._mappings.getTypeMapping(input.getType());
                Object id = typeMapping.toId(input.getId());
                return new DefaultIndexResponseWrapper(input, id);
            }
        });
    }

    @Override
    public ListenableActionFuture<GetResponseWrapper> get(Class<?> type, Object id) {
        return this.executeGet(new Get(type, id));
    }

    @Override
    public ListenableActionFuture<GetResponseWrapper> executeGet(Esi4JOperation<ListenableActionFuture<GetResponse>> getOperation) {
        return ListenableActionFutureWrapper.wrap(this.execute(getOperation), new Function<GetResponse, GetResponseWrapper>(){

            public GetResponseWrapper apply(GetResponse input) {
                TypeMapping typeMapping = DefaultIndex.this._mappings.getTypeMapping(input.getType());
                Object object = typeMapping.read(input);
                return new DefaultGetResponseWrapper(input, object);
            }
        });
    }

    @Override
    public ListenableActionFuture<DeleteResponseWrapper> executeDelete(Esi4JOperation<ListenableActionFuture<DeleteResponse>> deleteOperation) {
        return ListenableActionFutureWrapper.wrap(this.execute(deleteOperation), new Function<DeleteResponse, DeleteResponseWrapper>(){

            public DeleteResponseWrapper apply(DeleteResponse input) {
                return new DefaultDeleteResponseWrapper(input);
            }
        });
    }

    @Override
    public ListenableActionFuture<DeleteResponseWrapper> delete(Object object) {
        TypeMapping typeMapping = this._mappings.findTypeMapping(object);
        return this.executeDelete(new Delete(typeMapping.getTypeClass(), typeMapping.getId(object)));
    }

    @Override
    public ListenableActionFuture<DeleteResponseWrapper> delete(Class<?> type, Object id) {
        return this.executeDelete(new Delete(type, id));
    }

    @Override
    public ListenableActionFuture<BulkResponseWrapper> bulkIndex(final Iterable<?> iterable) {
        return this.executeBulk(new Esi4JOperation<ListenableActionFuture<BulkResponse>>(){

            @Override
            public ListenableActionFuture<BulkResponse> execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
                BulkRequestBuilder request = client.prepareBulk();
                for (Object o : iterable) {
                    TypeMapping mapping = helper.findTypeMapping(o);
                    IndexRequestBuilder index = mapping.indexRequest(client, indexName, o);
                    if (index == null) continue;
                    request.add(index);
                }
                return request.execute();
            }
        });
    }

    @Override
    public ListenableActionFuture<BulkResponseWrapper> executeBulk(Esi4JOperation<ListenableActionFuture<BulkResponse>> bulkOperation) {
        return ListenableActionFutureWrapper.wrap(this.execute(bulkOperation), new Function<BulkResponse, BulkResponseWrapper>(){

            public BulkResponseWrapper apply(BulkResponse response) {
                return new DefaultBulkResponseWrapper(response);
            }
        });
    }

    @Override
    public void refresh() {
        ListenableActionFuture<RefreshResponse> future = this._store.execute(new Esi4JStore.StoreOperation<ListenableActionFuture<RefreshResponse>>(){

            @Override
            public ListenableActionFuture<RefreshResponse> execute(Client client, String indexName) {
                return client.admin().indices().prepareRefresh(new String[]{indexName}).execute();
            }
        });
        future.actionGet();
    }

    @Override
    public Esi4JIndexManager getIndexManager() {
        return this._indexManager;
    }

    @Override
    public void setIndexManager(Esi4JIndexManager indexManager) {
        if (this._indexManager != null) {
            throw new IllegalStateException("indexManager already assigned");
        }
        this._indexManager = indexManager;
    }

    private static final class Delete
    implements Esi4JOperation<ListenableActionFuture<DeleteResponse>> {
        private final Class<?> _type;
        private final Object _id;

        private Delete(Class<?> type, Object id) {
            if (type == null) {
                throw new NullPointerException("type");
            }
            if (id == null) {
                throw new NullPointerException("id");
            }
            this._type = type;
            this._id = id;
        }

        @Override
        @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="_id not null at this point")
        public ListenableActionFuture<DeleteResponse> execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
            TypeMapping typeMapping = helper.findTypeMapping(this._type);
            return typeMapping.deleteRequest(client, indexName, typeMapping.toIdString(this._id), null).execute();
        }
    }

    private static final class Get
    implements Esi4JOperation<ListenableActionFuture<GetResponse>> {
        private final Class<?> _type;
        private final Object _id;

        private Get(Class<?> type, Object id) {
            if (type == null) {
                throw new NullPointerException("type");
            }
            if (id == null) {
                throw new NullPointerException("id");
            }
            this._type = type;
            this._id = id;
        }

        @Override
        public ListenableActionFuture<GetResponse> execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
            TypeMapping typeMapping = helper.findTypeMapping(this._type);
            String type = typeMapping.getTypeAlias();
            String id = typeMapping.toIdString(this._id);
            return client.prepareGet(indexName, type, id).execute();
        }
    }

    private static final class Index
    implements Esi4JOperation<ListenableActionFuture<IndexResponse>> {
        private final Object _object;

        private Index(Object object) {
            if (object == null) {
                throw new NullPointerException("object");
            }
            this._object = object;
        }

        @Override
        public ListenableActionFuture<IndexResponse> execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
            TypeMapping typeMapping = helper.findTypeMapping(this._object);
            IndexRequestBuilder request = typeMapping.indexRequest(client, indexName, this._object);
            if (request == null) {
                throw new Esi4JObjectFilteredException(typeMapping, this._object);
            }
            return request.execute();
        }
    }
}

