/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.core.impl;

import at.molindo.esi4j.core.Esi4JClient;
import at.molindo.esi4j.core.Esi4JIndex;
import at.molindo.esi4j.core.Esi4JStore;
import at.molindo.esi4j.core.impl.NodeClient;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.utils.data.StringUtils;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.settings.IndexDynamicSettings;
import org.elasticsearch.node.internal.InternalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStore
implements Esi4JStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultStore.class);
    private static final long INDEX_CREATION_TIMEOUT_SECONDS = 30L;
    private final Esi4JClient _client;
    private final String _indexName;
    private Esi4JIndex _index;

    public DefaultStore(Esi4JClient client, String indexName) {
        if (client == null) {
            throw new NullPointerException("client");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName");
        }
        this._client = client;
        this._indexName = indexName;
    }

    @Override
    public Esi4JClient getClient() {
        return this._client;
    }

    @Override
    public String getIndexName() {
        return this._indexName;
    }

    public Esi4JIndex getIndex() {
        return this._index;
    }

    @Override
    public void setIndex(Esi4JIndex index) {
        if (index == null) {
            throw new NullPointerException("index");
        }
        if (index != this._index) {
            if (this._index != null) {
                throw new IllegalStateException("already assigned to another index");
            }
            this._index = index;
            this.init(this._index);
        }
    }

    protected void init(Esi4JIndex index) {
        this.assertIndex(index);
        this._client.addStore(this);
    }

    void assertIndex(Esi4JIndex index) {
        IndicesExistsResponse existsResponse = (IndicesExistsResponse)this._client.getClient().admin().indices().prepareExists(new String[]{this._indexName}).execute().actionGet();
        if (!existsResponse.isExists()) {
            CreateIndexResponse response;
            CreateIndexRequestBuilder request = this._client.getClient().admin().indices().prepareCreate(this._indexName);
            Settings settings = this.getStoreSettings(index);
            if (settings != null) {
                request.setSettings(settings);
            }
            if (!(response = (CreateIndexResponse)request.setTimeout(TimeValue.timeValueSeconds((long)30L)).execute().actionGet()).isAcknowledged()) {
                log.warn("index creation not acknowledged within 30 seconds");
            }
        } else {
            Settings settings = this.getStoreSettings(index);
            if (settings != null && settings.getAsMap().size() > 0) {
                Settings storeSettings = this.toDynamicSettings(settings);
                this._client.getClient().admin().indices().prepareUpdateSettings(new String[]{this._indexName}).setSettings(storeSettings).execute().actionGet();
                ClusterStateResponse state = (ClusterStateResponse)this._client.getClient().admin().cluster().prepareState().setFilterIndices(new String[]{this._indexName}).setFilterAll().setFilterMetaData(false).execute().actionGet();
                Settings indexSettings = ((IndexMetaData)state.getState().getMetaData().getIndices().get(this._indexName)).getSettings();
                for (Map.Entry e : settings.getAsMap().entrySet()) {
                    String indexValue;
                    String key = (String)e.getKey();
                    String localValue = (String)e.getValue();
                    if (StringUtils.equals((String)localValue, (String)(indexValue = indexSettings.get(key.startsWith("index.") ? key : "index." + key)))) continue;
                    log.warn("could not update value for settings key '" + key + "' from ('" + indexValue + "' to '" + localValue + "') - delete and rebuild index " + this._indexName);
                }
            }
        }
    }

    private Settings toDynamicSettings(Settings settings) {
        InternalNode node = (InternalNode)((NodeClient)this.getClient()).getNode();
        DynamicSettings indexDynamicSettings = ((DynamicSettingsBean)node.injector().getInstance(DynamicSettingsBean.class)).getIndexDynamicSettings();
        ImmutableSettings.Builder dynamicSettings = ImmutableSettings.builder();
        for (Map.Entry e : settings.getAsMap().entrySet()) {
            if (!indexDynamicSettings.hasDynamicSetting((String)e.getKey())) continue;
            String error = indexDynamicSettings.validateDynamicSetting((String)e.getKey(), (String)e.getValue());
            if (error == null) {
                dynamicSettings.put((String)e.getKey(), (String)e.getValue());
                continue;
            }
            throw new IllegalArgumentException("index setting " + (String)e.getKey() + " has invalid value '" + (String)e.getValue() + " (" + error + ")");
        }
        return dynamicSettings.build();
    }

    private Settings getStoreSettings(Esi4JIndex index) {
        Settings indexSettings = ((InternalIndex)index).getSettings();
        if (indexSettings == null) {
            return null;
        }
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder();
        for (Map.Entry e : indexSettings.getAsMap().entrySet()) {
            if (!((String)e.getKey()).startsWith("index.")) continue;
            builder.put((String)e.getKey(), (String)e.getValue());
        }
        return builder.build();
    }

    @Override
    public <T> T execute(Esi4JStore.StoreOperation<T> operation) {
        if (this._index == null) {
            throw new IllegalStateException("store not assigned to an index");
        }
        return operation.execute(this._client.getClient(), this._indexName);
    }

    @Override
    public void close() {
        this._client.removeStore(this);
    }

    public static final class DynamicSettingsBean {
        private final DynamicSettings _clusterDynamicSettings;
        private final DynamicSettings _indexDynamicSettings;

        @Inject
        public DynamicSettingsBean(@ClusterDynamicSettings DynamicSettings clusterDynamicSettings, @IndexDynamicSettings DynamicSettings indexDynamicSettings) {
            this._clusterDynamicSettings = clusterDynamicSettings;
            this._indexDynamicSettings = indexDynamicSettings;
        }

        public DynamicSettings getClusterDynamicSettings() {
            return this._clusterDynamicSettings;
        }

        public DynamicSettings getIndexDynamicSettings() {
            return this._indexDynamicSettings;
        }
    }
}

