/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.core.impl;

import at.molindo.esi4j.core.Esi4JClient;
import at.molindo.esi4j.core.Esi4JStore;
import at.molindo.utils.collections.IdentityHashSet;
import org.elasticsearch.client.Client;

public class TransportClient
implements Esi4JClient {
    private String _id;
    private Client _client;
    private IdentityHashSet<Esi4JStore> _referrers = new IdentityHashSet();

    public TransportClient(String clusterName, Client client) {
        if (client == null) {
            throw new NullPointerException("node");
        }
        this._id = clusterName;
        this._client = client;
    }

    @Override
    public String getClusterName() {
        return this._id;
    }

    @Override
    public Client getClient() {
        return this._client;
    }

    @Override
    public void addStore(Esi4JStore store) {
        this._referrers.add((Object)store);
    }

    @Override
    public void removeStore(Esi4JStore store) {
        this._referrers.remove((Object)store);
        if (this._referrers.size() == 0) {
            // empty if block
        }
    }

    @Override
    public void close() {
        this._client.close();
    }
}

