/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.core.impl;

import at.molindo.esi4j.core.Esi4JClient;
import at.molindo.esi4j.core.Esi4JClientFactory;
import at.molindo.esi4j.core.impl.TransportClient;
import at.molindo.utils.collections.ArrayUtils;
import at.molindo.utils.data.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class TransportClientFactory
implements Esi4JClientFactory {
    private final Settings _settings;
    private final String _clusterName;
    private final String[] _hosts;

    public TransportClientFactory(Settings settings) {
        this._settings = settings;
        this._clusterName = settings.get("cluster.name", ClusterName.DEFAULT.value());
        this._hosts = settings.getAsArray("esi4j.client.transport.hosts");
        if (ArrayUtils.empty((Object[])this._hosts)) {
            throw new IllegalArgumentException("hosts required");
        }
    }

    @Override
    public Esi4JClient create() {
        org.elasticsearch.client.transport.TransportClient client = new org.elasticsearch.client.transport.TransportClient(this._settings);
        String[] parts = new String[2];
        for (String host : this._hosts) {
            if (StringUtils.split((String)host, (String)":", (String[])parts) == 1) {
                parts[1] = "9300";
            }
            client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(parts[0], Integer.parseInt(parts[1])));
        }
        return new TransportClient(this._clusterName, (Client)client);
    }
}

