/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.mapping;

import java.util.Map;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;

public interface ObjectSource {
    public void setSource(IndexRequestBuilder var1);

    public void setSource(IndexRequest var1);

    public static final class Builder {
        private Builder() {
        }

        public static ObjectSource builder(final XContentBuilder source) {
            return new ObjectSource(){

                @Override
                public void setSource(IndexRequestBuilder request) {
                    request.setSource(source);
                }

                @Override
                public void setSource(IndexRequest request) {
                    request.source(source);
                }
            };
        }

        public static ObjectSource string(final String source) {
            return new ObjectSource(){

                @Override
                public void setSource(IndexRequestBuilder request) {
                    request.setSource(source);
                }

                @Override
                public void setSource(IndexRequest request) {
                    request.source(source);
                }
            };
        }

        public static ObjectSource map(final Map<String, Object> source) {
            return new ObjectSource(){

                @Override
                public void setSource(IndexRequestBuilder request) {
                    request.setSource(source);
                }

                @Override
                public void setSource(IndexRequest request) {
                    request.source(source);
                }
            };
        }

        public static ObjectSource map(final Map<String, Object> source, final XContentType contentType) {
            return new ObjectSource(){

                @Override
                public void setSource(IndexRequestBuilder request) {
                    request.setSource(source, contentType);
                }

                @Override
                public void setSource(IndexRequest request) {
                    request.source(source);
                }
            };
        }
    }
}

