/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.mapping;

import at.molindo.esi4j.mapping.MappingSource;
import at.molindo.esi4j.mapping.ObjectSource;
import at.molindo.utils.data.StringUtils;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.SearchHit;

public abstract class TypeMapping {
    public static final String FIELD_INDEX = "_index";
    public static final String FIELD_TYPE = "_type";
    public static final String FIELD_ID = "_id";
    public static final String FIELD_VERSION = "_version";
    private final String _typeAlias;

    public TypeMapping(String typeAlias) {
        if (StringUtils.empty((String)typeAlias)) {
            throw new IllegalArgumentException("typeAlias must not be empty");
        }
        this._typeAlias = typeAlias;
    }

    public String getTypeAlias() {
        return this._typeAlias;
    }

    public abstract Class<?> getTypeClass();

    public abstract Class<?> getIdClass();

    public boolean isFiltered(@Nonnull Object o) {
        return false;
    }

    public abstract boolean isVersioned();

    public abstract Object getId(@Nonnull Object var1);

    public final String getIdString(@Nonnull Object o) {
        Object id = this.getId(o);
        return id == null ? null : this.toIdString(id);
    }

    public abstract String toIdString(@Nonnull Object var1);

    public abstract Object toId(@Nonnull String var1);

    public abstract Long getVersion(Object var1);

    public abstract MappingSource getMappingSource();

    public abstract ObjectSource getObjectSource(Object var1);

    @CheckForNull
    public abstract Object read(GetResponse var1);

    @CheckForNull
    public abstract Object read(SearchHit var1);

    @CheckForNull
    public final IndexRequestBuilder indexRequest(Client client, String indexName, Object o) {
        return this.populate(client.prepareIndex(), indexName, o);
    }

    @CheckForNull
    public final IndexRequest indexRequest(String indexName, Object o) {
        IndexRequestBuilder builder = this.populate(new IndexRequestBuilder(null), indexName, o);
        return builder == null ? null : (IndexRequest)builder.request();
    }

    private IndexRequestBuilder populate(IndexRequestBuilder builder, String indexName, @Nullable Object o) {
        if (o != null && !this.isFiltered(o)) {
            ((IndexRequestBuilder)builder.setIndex(indexName)).setType(this.getTypeAlias()).setId(this.getIdString(o));
            Long version = this.getVersion(o);
            if (version != null) {
                builder.setVersion(version.longValue()).setVersionType(VersionType.EXTERNAL);
            }
            this.getObjectSource(o).setSource(builder);
            return builder;
        }
        return null;
    }

    @CheckForNull
    public final DeleteRequest deleteRequest(String indexName, Object o) {
        return this.deleteRequest(indexName, this.getIdString(o), this.getVersion(o));
    }

    @CheckForNull
    public final DeleteRequest deleteRequest(String indexName, String id, Long version) {
        DeleteRequestBuilder builder = this.populate(new DeleteRequestBuilder(null), indexName, id, version);
        return builder == null ? null : (DeleteRequest)builder.request();
    }

    @CheckForNull
    public final DeleteRequestBuilder deleteRequest(Client client, String indexName, Object o) {
        return this.deleteRequest(client, indexName, this.getIdString(o), this.getVersion(o));
    }

    @CheckForNull
    public final DeleteRequestBuilder deleteRequest(Client client, String indexName, String id, Long version) {
        return this.populate(client.prepareDelete(), indexName, id, version);
    }

    private final DeleteRequestBuilder populate(DeleteRequestBuilder builder, String indexName, String id, Long version) {
        if (id == null) {
            return null;
        }
        ((DeleteRequestBuilder)builder.setIndex(indexName)).setType(this.getTypeAlias()).setId(id);
        if (version != null) {
            builder.setVersion(version + 1L).setVersionType(VersionType.EXTERNAL);
        }
        return builder;
    }
}

