/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.mapping;

import at.molindo.esi4j.mapping.TypeMapping;
import at.molindo.utils.data.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

public class TypeMappings {
    private ConcurrentHashMap<Class<?>, TypeMapping> _mappingsByClass = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TypeMapping> _mappingsByAlias = new ConcurrentHashMap();

    public void addMapping(TypeMapping mapping) {
        String typeAlias = mapping.getTypeAlias();
        if (StringUtils.empty((String)typeAlias)) {
            throw new IllegalArgumentException("typeAlias must not be empty");
        }
        TypeMapping prev = this._mappingsByAlias.putIfAbsent(typeAlias, mapping);
        if (prev != null && prev != mapping) {
            throw new IllegalArgumentException("duplicate type alias " + mapping.getTypeAlias());
        }
        prev = this._mappingsByClass.putIfAbsent(mapping.getTypeClass(), mapping);
        if (prev != null && prev != mapping) {
            this._mappingsByAlias.remove(typeAlias);
            throw new IllegalArgumentException("duplicate type class " + mapping.getTypeClass().getName());
        }
    }

    public TypeMapping getTypeMapping(String typeAlias) {
        if (StringUtils.empty((String)typeAlias)) {
            return null;
        }
        return this._mappingsByAlias.get(typeAlias);
    }

    public TypeMapping getTypeMapping(Object o) {
        return this.getTypeMapping(this.toType(o));
    }

    public TypeMapping getTypeMapping(Class<?> type) {
        if (type == null) {
            return null;
        }
        TypeMapping mapping = this._mappingsByClass.get(type);
        while (mapping == null && (type = type.getSuperclass()) != null) {
            mapping = this._mappingsByClass.get(type);
        }
        return mapping;
    }

    public TypeMapping findTypeMapping(String typeAlias) {
        TypeMapping mapping = this.getTypeMapping(typeAlias);
        if (mapping == null) {
            throw new IllegalArgumentException("unknown type " + typeAlias);
        }
        return mapping;
    }

    public TypeMapping findTypeMapping(Object o) {
        return this.findTypeMapping(this.toType(o));
    }

    public TypeMapping findTypeMapping(Class<?> type) {
        TypeMapping mapping = this.getTypeMapping(type);
        if (mapping == null) {
            throw new IllegalArgumentException("unknown class " + type.getName());
        }
        return mapping;
    }

    private Class<? extends Object> toType(Object o) {
        return o == null ? null : o.getClass();
    }

    public Iterable<TypeMapping> getTypeMappings() {
        return Collections.unmodifiableCollection(this._mappingsByAlias.values());
    }

    public Class<?>[] getMappedTypes() {
        ArrayList list = new ArrayList(this._mappingsByClass.keySet());
        return list.toArray(new Class[list.size()]);
    }

    public String[] getMappedAliases() {
        ArrayList list = new ArrayList(this._mappingsByAlias.keySet());
        return list.toArray(new String[list.size()]);
    }
}

