/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.mapping.impl;

import at.molindo.esi4j.mapping.MappingSource;
import at.molindo.esi4j.mapping.ObjectSource;
import at.molindo.esi4j.mapping.TypeMapping;
import at.molindo.utils.collections.CollectionUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;

public abstract class GenericTypeMapping<Type, Id>
extends TypeMapping {
    private final Class<Type> _typeClass;
    private final Class<Id> _idClass;
    private String _mapping;

    public GenericTypeMapping(String typeAlias, Class<Type> typeClass, Class<Id> idClass) {
        super(typeAlias);
        if (typeClass == null) {
            throw new NullPointerException("typeClass");
        }
        if (idClass == null) {
            throw new NullPointerException("idClass");
        }
        this._typeClass = typeClass;
        this._idClass = idClass;
    }

    @Override
    public final MappingSource getMappingSource() {
        try {
            if (this._mapping == null || this.isDynamicMapping()) {
                RootObjectMapper.Builder mapperBuilder = new RootObjectMapper.Builder(this.getTypeAlias());
                this.buildMapping(mapperBuilder);
                XContentBuilder contentBuilder = JsonXContent.contentBuilder();
                contentBuilder.startObject();
                ((RootObjectMapper)mapperBuilder.build(new Mapper.BuilderContext(null, new ContentPath()))).toXContent(contentBuilder, null, new ToXContent(){

                    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                        ImmutableMap<String, Object> meta = GenericTypeMapping.this.meta();
                        if (meta != null && !meta.isEmpty()) {
                            builder.field("_meta", meta);
                        }
                        return builder;
                    }
                }, new Mapper[0]);
                contentBuilder.endObject();
                this._mapping = contentBuilder.string();
            }
            return MappingSource.Builder.string(this._mapping);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public boolean isDynamicMapping() {
        return false;
    }

    public ImmutableMap<String, Object> meta() {
        return null;
    }

    @Override
    public ObjectSource getObjectSource(Object o) {
        try {
            return ObjectSource.Builder.builder(this.getContentBuilder(o));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final XContentBuilder getContentBuilder(Object o) throws IOException {
        XContentBuilder contentBuilder = JsonXContent.contentBuilder();
        this.write(contentBuilder, o);
        return contentBuilder;
    }

    public final void write(XContentBuilder contentBuilder, Object o) throws IOException {
        contentBuilder.startObject();
        String id = this.getIdString(o);
        if (id != null) {
            contentBuilder.field("_id").value(id);
        }
        this.writeObject(contentBuilder, this.cast(o));
        contentBuilder.endObject();
    }

    public final Type read(GetResponse response) {
        return response.isExists() ? (Type)this.read(this.getSource(response)) : null;
    }

    public final Type read(SearchHit hit) {
        return this.read(this.getSource(hit));
    }

    protected Map<String, Object> getSource(GetResponse response) {
        Map map = response.getSource();
        if (map == null) {
            map = Maps.newHashMap();
            for (Map.Entry e : response.getFields().entrySet()) {
                List values = ((GetField)e.getValue()).getValues();
                if (CollectionUtils.empty((Collection)values)) continue;
                map.put(e.getKey(), values.size() == 1 ? values.get(0) : values);
            }
        }
        map.put("_index", response.getIndex());
        map.put("_type", response.getType());
        map.put("_id", response.getId());
        if (response.getVersion() != -1L) {
            map.put("_version", response.getVersion());
        }
        return map;
    }

    protected Map<String, Object> getSource(SearchHit hit) {
        Map map = hit.sourceAsMap();
        if (map == null) {
            map = Maps.newHashMap();
            for (Map.Entry e : hit.getFields().entrySet()) {
                List values = ((SearchHitField)e.getValue()).getValues();
                if (CollectionUtils.empty((Collection)values)) continue;
                map.put(e.getKey(), values.size() == 1 ? values.get(0) : values);
            }
        }
        map.put("_index", hit.getIndex());
        map.put("_type", hit.getType());
        map.put("_id", hit.getId());
        if (hit.getVersion() != -1L) {
            map.put("_version", hit.getVersion());
        }
        return map;
    }

    public Class<Type> getTypeClass() {
        return this._typeClass;
    }

    public Class<Id> getIdClass() {
        return this._idClass;
    }

    protected Type cast(Object o) {
        return this.getTypeClass().cast(o);
    }

    protected Id castId(Object o) {
        return this.getIdClass().cast(o);
    }

    @Override
    public final boolean isFiltered(Object entity) {
        return this.filter(this.cast(entity));
    }

    public final Id getId(Object o) {
        return this.id(this.cast(o));
    }

    @Override
    public Long getVersion(Object o) {
        return this.version(this.cast(o));
    }

    protected boolean filter(Type o) {
        return false;
    }

    @Override
    public final String toIdString(Object id) {
        return this.toString(this.castId(id));
    }

    public abstract String toString(Id var1);

    public abstract Id toId(String var1);

    protected abstract Id id(Type var1);

    protected abstract Long version(Type var1);

    protected abstract void buildMapping(RootObjectMapper.Builder var1) throws IOException;

    protected abstract void writeObject(XContentBuilder var1, Type var2) throws IOException;

    public abstract Type read(Map<String, Object> var1);
}

