/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.module.es;

import at.molindo.esi4j.core.Esi4JOperation;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.mapping.TypeMapping;
import at.molindo.esi4j.module.Esi4JModule;
import at.molindo.esi4j.rebuild.Esi4JRebuildSession;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;

public class ElasticsearchModule
implements Esi4JModule {
    private final TransportClient _client;
    private final InternalIndex _index;

    public ElasticsearchModule(Settings transportClientSettings, InternalIndex index) {
        if (transportClientSettings == null) {
            throw new NullPointerException("transportClientSettings");
        }
        if (index == null) {
            throw new NullPointerException("index");
        }
        this._client = new TransportClient(transportClientSettings);
        this._index = index;
    }

    @Override
    public Esi4JRebuildSession startRebuildSession(final Class<?> type) {
        return this._index.execute(new Esi4JOperation<Esi4JRebuildSession>(){

            @Override
            public Esi4JRebuildSession execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
                final TypeMapping mapping = helper.findTypeMapping(type);
                return new Esi4JRebuildSession(){
                    private final long _scrollTimeoutSeconds = 60L;
                    private String _scrollId;
                    private boolean _endReached = false;

                    @Override
                    public boolean isOrdered() {
                        return true;
                    }

                    @Override
                    public Class<?> getType() {
                        return type;
                    }

                    @Override
                    public List<?> getNext(int batchSize) {
                        ActionFuture responseFuture;
                        if (this._endReached) {
                            throw new IllegalStateException("reached end");
                        }
                        if (this._scrollId == null) {
                            SearchRequestBuilder builder = new SearchRequestBuilder((Client)ElasticsearchModule.this._client).setIndices(new String[]{mapping.getTypeAlias()}).setFilter((FilterBuilder)FilterBuilders.matchAllFilter()).setScroll(TimeValue.timeValueSeconds((long)60L)).addSort("_id", SortOrder.ASC).setSize(batchSize);
                            responseFuture = ElasticsearchModule.this._client.search(builder.request());
                        } else {
                            responseFuture = ElasticsearchModule.this._client.searchScroll((SearchScrollRequest)new SearchScrollRequestBuilder((Client)ElasticsearchModule.this._client, this._scrollId).request());
                        }
                        SearchResponse response = (SearchResponse)responseFuture.actionGet();
                        SearchHit[] hits = response.getHits().getHits();
                        ArrayList<Object> list = new ArrayList<Object>(hits.length);
                        if (hits.length == 0) {
                            this._endReached = true;
                            this._scrollId = null;
                        } else {
                            this._scrollId = response.getScrollId();
                            for (int i = 0; i < hits.length; ++i) {
                                Object o = mapping.read(hits[i]);
                                if (o == null) continue;
                                list.add(o);
                            }
                        }
                        return list;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        });
    }

    @Override
    public Class<?>[] getTypes() {
        return this._index.getMappedTypes();
    }

    @Override
    public void close() {
        this._client.close();
    }
}

