/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.module.hibernate;

import at.molindo.esi4j.chain.Esi4JBatchedEventProcessor;
import at.molindo.esi4j.module.hibernate.HibernateEventListener;
import at.molindo.esi4j.module.hibernate.HibernateLifecycleInjector;
import at.molindo.utils.collections.ArrayUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.hibernate.SessionFactory;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.impl.SessionFactoryImpl;

public class DefaultHibernateLifecycleInjector
implements HibernateLifecycleInjector {
    private final boolean registerPostCommitListeneres;

    public DefaultHibernateLifecycleInjector() {
        this(true);
    }

    public DefaultHibernateLifecycleInjector(boolean registerPostCommitListeneres) {
        this.registerPostCommitListeneres = registerPostCommitListeneres;
    }

    @Override
    public void injectLifecycle(SessionFactory sessionFactory, Esi4JBatchedEventProcessor batchedEventProcessor) {
        Object[] listeners;
        SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)sessionFactory;
        EventListeners eventListeners = sessionFactoryImpl.getEventListeners();
        Object listener = this.doCreateListener(sessionFactoryImpl, batchedEventProcessor);
        if (listener instanceof PostInsertEventListener) {
            if (this.registerPostCommitListeneres) {
                listeners = eventListeners.getPostCommitInsertEventListeners();
                listeners = (PostInsertEventListener[])ArrayUtils.append((Object[])listeners, (Object)((PostInsertEventListener)listener));
                eventListeners.setPostCommitInsertEventListeners((PostInsertEventListener[])listeners);
            } else {
                listeners = eventListeners.getPostInsertEventListeners();
                listeners = (PostInsertEventListener[])ArrayUtils.append((Object[])listeners, (Object)((PostInsertEventListener)listener));
                eventListeners.setPostInsertEventListeners((PostInsertEventListener[])listeners);
            }
        }
        if (listener instanceof PostUpdateEventListener) {
            if (this.registerPostCommitListeneres) {
                listeners = eventListeners.getPostCommitUpdateEventListeners();
                listeners = (PostUpdateEventListener[])ArrayUtils.append((Object[])listeners, (Object)((PostUpdateEventListener)listener));
                eventListeners.setPostCommitUpdateEventListeners((PostUpdateEventListener[])listeners);
            } else {
                listeners = eventListeners.getPostUpdateEventListeners();
                listeners = (PostUpdateEventListener[])ArrayUtils.append((Object[])listeners, (Object)((PostUpdateEventListener)listener));
                eventListeners.setPostUpdateEventListeners((PostUpdateEventListener[])listeners);
            }
        }
        if (listener instanceof PostDeleteEventListener) {
            if (this.registerPostCommitListeneres) {
                listeners = eventListeners.getPostCommitDeleteEventListeners();
                listeners = (PostDeleteEventListener[])ArrayUtils.append((Object[])listeners, (Object)((PostDeleteEventListener)listener));
                eventListeners.setPostCommitDeleteEventListeners((PostDeleteEventListener[])listeners);
            } else {
                listeners = eventListeners.getPostDeleteEventListeners();
                listeners = (PostDeleteEventListener[])ArrayUtils.append((Object[])listeners, (Object)((PostDeleteEventListener)listener));
                eventListeners.setPostDeleteEventListeners((PostDeleteEventListener[])listeners);
            }
        }
        if (this.registerPostCommitListeneres) {
            return;
        }
        if (listener instanceof PostCollectionRecreateEventListener) {
            listeners = eventListeners.getPostCollectionRecreateEventListeners();
            listeners = (PostCollectionRecreateEventListener[])ArrayUtils.append((Object[])listeners, (Object)((PostCollectionRecreateEventListener)listener));
            eventListeners.setPostCollectionRecreateEventListeners((PostCollectionRecreateEventListener[])listeners);
        }
        if (listener instanceof PostCollectionRemoveEventListener) {
            listeners = eventListeners.getPostCollectionRemoveEventListeners();
            listeners = (PostCollectionRemoveEventListener[])ArrayUtils.append((Object[])listeners, (Object)((PostCollectionRemoveEventListener)listener));
            eventListeners.setPostCollectionRemoveEventListeners((PostCollectionRemoveEventListener[])listeners);
        }
        if (listener instanceof PostCollectionUpdateEventListener) {
            listeners = eventListeners.getPostCollectionUpdateEventListeners();
            listeners = (PostCollectionUpdateEventListener[])ArrayUtils.append((Object[])listeners, (Object)((PostCollectionUpdateEventListener)listener));
            eventListeners.setPostCollectionUpdateEventListeners((PostCollectionUpdateEventListener[])listeners);
        }
    }

    @Override
    public void removeLifecycle(SessionFactory sessionFactory) {
        SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)sessionFactory;
        EventListeners eventListeners = sessionFactoryImpl.getEventListeners();
        PostInsertEventListener[] postInsertEventListeners = this.registerPostCommitListeneres ? eventListeners.getPostCommitInsertEventListeners() : eventListeners.getPostInsertEventListeners();
        ArrayList tempPostInsertEventListeners = Lists.newArrayList();
        for (int i = 0; i < postInsertEventListeners.length; ++i) {
            PostInsertEventListener postInsertEventListener = postInsertEventListeners[i];
            if (postInsertEventListener instanceof HibernateEventListener) continue;
            tempPostInsertEventListeners.add(postInsertEventListener);
        }
        if (this.registerPostCommitListeneres) {
            eventListeners.setPostCommitInsertEventListeners(tempPostInsertEventListeners.toArray(new PostInsertEventListener[tempPostInsertEventListeners.size()]));
        } else {
            eventListeners.setPostInsertEventListeners(tempPostInsertEventListeners.toArray(new PostInsertEventListener[tempPostInsertEventListeners.size()]));
        }
        PostUpdateEventListener[] postUpdateEventListeners = this.registerPostCommitListeneres ? eventListeners.getPostCommitUpdateEventListeners() : eventListeners.getPostUpdateEventListeners();
        ArrayList tempPostUpdateEventListeners = Lists.newArrayList();
        for (int i = 0; i < postUpdateEventListeners.length; ++i) {
            PostUpdateEventListener postUpdateEventListener = postUpdateEventListeners[i];
            if (postUpdateEventListener instanceof HibernateEventListener) continue;
            tempPostUpdateEventListeners.add(postUpdateEventListener);
        }
        if (this.registerPostCommitListeneres) {
            eventListeners.setPostCommitUpdateEventListeners(tempPostUpdateEventListeners.toArray(new PostUpdateEventListener[tempPostUpdateEventListeners.size()]));
        } else {
            eventListeners.setPostUpdateEventListeners(tempPostUpdateEventListeners.toArray(new PostUpdateEventListener[tempPostUpdateEventListeners.size()]));
        }
        PostDeleteEventListener[] postDeleteEventListeners = this.registerPostCommitListeneres ? eventListeners.getPostCommitDeleteEventListeners() : eventListeners.getPostDeleteEventListeners();
        ArrayList tempPostDeleteEventListeners = Lists.newArrayList();
        for (int i = 0; i < postDeleteEventListeners.length; ++i) {
            PostDeleteEventListener postDeleteEventListener = postDeleteEventListeners[i];
            if (postDeleteEventListener instanceof HibernateEventListener) continue;
            tempPostDeleteEventListeners.add(postDeleteEventListener);
        }
        if (this.registerPostCommitListeneres) {
            eventListeners.setPostCommitDeleteEventListeners(tempPostDeleteEventListeners.toArray(new PostDeleteEventListener[tempPostDeleteEventListeners.size()]));
        } else {
            eventListeners.setPostDeleteEventListeners(tempPostDeleteEventListeners.toArray(new PostDeleteEventListener[tempPostDeleteEventListeners.size()]));
        }
        if (this.registerPostCommitListeneres) {
            return;
        }
        PostCollectionRecreateEventListener[] postCollectionRecreateEventListeners = eventListeners.getPostCollectionRecreateEventListeners();
        ArrayList tempPostCollectionRecreateEventListeners = Lists.newArrayList();
        for (PostCollectionRecreateEventListener postCollectionRecreateEventListener : postCollectionRecreateEventListeners) {
            if (postCollectionRecreateEventListener instanceof HibernateEventListener) continue;
            tempPostCollectionRecreateEventListeners.add(postCollectionRecreateEventListener);
        }
        eventListeners.setPostCollectionRecreateEventListeners(tempPostCollectionRecreateEventListeners.toArray(new PostCollectionRecreateEventListener[tempPostCollectionRecreateEventListeners.size()]));
        PostCollectionUpdateEventListener[] postCollectionUpdateEventListeners = eventListeners.getPostCollectionUpdateEventListeners();
        ArrayList tempPostCollectionUpdateEventListeners = Lists.newArrayList();
        for (PostCollectionUpdateEventListener postCollectionUpdateEventListener : postCollectionUpdateEventListeners) {
            if (postCollectionUpdateEventListener instanceof HibernateEventListener) continue;
            tempPostCollectionUpdateEventListeners.add(postCollectionUpdateEventListener);
        }
        eventListeners.setPostCollectionUpdateEventListeners(tempPostCollectionUpdateEventListeners.toArray(new PostCollectionUpdateEventListener[tempPostCollectionUpdateEventListeners.size()]));
        PostCollectionRemoveEventListener[] postCollectionRemoveEventListeners = eventListeners.getPostCollectionRemoveEventListeners();
        ArrayList tempPostCollectionRemoveEventListeners = Lists.newArrayList();
        for (PostCollectionRemoveEventListener postCollectionRemoveEventListener : postCollectionRemoveEventListeners) {
            if (postCollectionRemoveEventListener instanceof HibernateEventListener) continue;
            tempPostCollectionRemoveEventListeners.add(postCollectionRemoveEventListener);
        }
        eventListeners.setPostCollectionRemoveEventListeners(tempPostCollectionRemoveEventListeners.toArray(new PostCollectionRemoveEventListener[tempPostCollectionRemoveEventListeners.size()]));
    }

    protected Object doCreateListener(SessionFactoryImpl sessionFactory, Esi4JBatchedEventProcessor batchedEventProcessor) {
        return new HibernateEventListener(batchedEventProcessor);
    }
}

