/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.module.hibernate;

import at.molindo.esi4j.chain.Esi4JEntityResolver;
import at.molindo.utils.collections.ClassMap;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.SessionImpl;
import org.hibernate.metadata.ClassMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateEntityResolver
implements Esi4JEntityResolver {
    private static final Logger log = LoggerFactory.getLogger(HibernateEntityResolver.class);
    private final SessionFactory _sessionFactory;
    private final ClassMap<String> _entityNames = ClassMap.create();
    private final ThreadLocal<Session> _localSession = new ThreadLocal();

    public HibernateEntityResolver(SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            throw new NullPointerException("sessionFactory");
        }
        for (Map.Entry e : sessionFactory.getAllClassMetadata().entrySet()) {
            Class mappedClass = ((ClassMetadata)e.getValue()).getMappedClass(EntityMode.POJO);
            if (mappedClass == null) continue;
            this._entityNames.put((Object)mappedClass, e.getKey());
        }
        this._sessionFactory = sessionFactory;
    }

    @Override
    public Esi4JEntityResolver.ObjectKey toObjectKey(Object entity) {
        SessionFactory factory = this.getSessionFactory();
        Session session = this.getCurrentSession(factory);
        String entityName = (String)this._entityNames.find(entity.getClass());
        ClassMetadata meta = factory.getClassMetadata(entityName);
        EntityMode entityMode = session.getEntityMode();
        Class type = meta.getMappedClass(entityMode);
        Serializable id = meta.getIdentifier(entity, (SessionImplementor)((SessionImpl)session));
        Long version = this.toLongVersion(meta.getVersion(entity, entityMode));
        return new Esi4JEntityResolver.ObjectKey(type, id, version);
    }

    private Long toLongVersion(Object version) {
        if (version instanceof Number) {
            return ((Number)version).longValue();
        }
        if (version instanceof Date) {
            return ((Date)version).getTime();
        }
        if (version != null) {
            log.warn("unexpected version type " + version.getClass().getName());
        }
        return null;
    }

    @Override
    public Object replaceEntity(Object entity) {
        return this.toObjectKey(entity);
    }

    public void openResolveSession() {
        Session session = this._localSession.get();
        if (session != null) {
            log.warn("session already open, now closing first");
            this.closeResolveSession();
            session = null;
        }
        session = this.getNewSession(this.getSessionFactory());
        session.setDefaultReadOnly(true);
        session.setCacheMode(CacheMode.GET);
        session.setFlushMode(FlushMode.MANUAL);
        session.beginTransaction();
        this._localSession.set(session);
    }

    public void closeResolveSession() {
        Session session = this._localSession.get();
        if (session != null) {
            session.getTransaction().commit();
            session.clear();
            session.close();
            this._localSession.set(null);
        } else {
            log.warn("session not open");
        }
    }

    @Override
    public Object resolveEntity(Object replacedEntity) {
        if (replacedEntity instanceof Esi4JEntityResolver.ObjectKey) {
            Esi4JEntityResolver.ObjectKey key = (Esi4JEntityResolver.ObjectKey)replacedEntity;
            Session session = this._localSession.get();
            if (session == null) {
                throw new IllegalStateException("no session available");
            }
            Object resolvedEntity = session.load(key.getType(), key.getId());
            if (resolvedEntity == null) {
                log.error("can't resolve object " + key);
                return null;
            }
            return resolvedEntity;
        }
        return replacedEntity;
    }

    protected Session getCurrentSession(SessionFactory factory) {
        return factory.getCurrentSession();
    }

    protected Session getNewSession(SessionFactory factory) {
        return factory.openSession();
    }

    public final SessionFactory getSessionFactory() {
        return this._sessionFactory;
    }
}

