/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.module.hibernate;

import at.molindo.esi4j.chain.Esi4JBatchedEventProcessor;
import com.google.common.collect.Maps;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Synchronization;
import org.hibernate.Transaction;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener {
    private static final Logger log = LoggerFactory.getLogger(HibernateEventListener.class);
    private static final long serialVersionUID = 1L;
    private final transient Esi4JBatchedEventProcessor _batchedEventProcessor;
    private final ConcurrentMap<Transaction, Esi4JBatchedEventProcessor.EventSession> _map = Maps.newConcurrentMap();

    public HibernateEventListener(Esi4JBatchedEventProcessor batchedEventProcessor) {
        if (batchedEventProcessor == null) {
            throw new NullPointerException("batchedEventProcessor");
        }
        this._batchedEventProcessor = batchedEventProcessor;
    }

    public void onPostInsert(PostInsertEvent event) {
        Esi4JBatchedEventProcessor.EventSession eventSession = this.findEventSession(event.getSession());
        if (eventSession != null) {
            eventSession.onPostInsert(event.getEntity());
        } else {
            this._batchedEventProcessor.onPostInsert(event.getEntity());
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Esi4JBatchedEventProcessor.EventSession eventSession = this.findEventSession(event.getSession());
        if (eventSession != null) {
            eventSession.onPostUpdate(event.getEntity());
        } else {
            this._batchedEventProcessor.onPostUpdate(event.getEntity());
        }
    }

    public void onPostDelete(PostDeleteEvent event) {
        Esi4JBatchedEventProcessor.EventSession eventSession = this.findEventSession(event.getSession());
        if (eventSession != null) {
            eventSession.onPostDelete(event.getEntity());
        } else {
            this._batchedEventProcessor.onPostDelete(event.getEntity());
        }
    }

    private Esi4JBatchedEventProcessor.EventSession findEventSession(EventSource hibernateSession) {
        if (hibernateSession.isTransactionInProgress()) {
            Transaction transaction = hibernateSession.getTransaction();
            Esi4JBatchedEventProcessor.EventSession session = (Esi4JBatchedEventProcessor.EventSession)this._map.get(transaction);
            if (session == null) {
                session = this._batchedEventProcessor.startSession();
                transaction.registerSynchronization((Synchronization)new Esi4JHibernateSynchronization(transaction));
                this._map.put(transaction, session);
            }
            return session;
        }
        return null;
    }

    Object writeReplace() throws ObjectStreamException {
        throw new NotSerializableException(HibernateEventListener.class.getName());
    }

    private final class Esi4JHibernateSynchronization
    implements Synchronization {
        private final Transaction _transaction;

        private Esi4JHibernateSynchronization(Transaction transaction) {
            if (transaction == null) {
                throw new NullPointerException("transaction");
            }
            this._transaction = transaction;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            Esi4JBatchedEventProcessor.EventSession session = (Esi4JBatchedEventProcessor.EventSession)HibernateEventListener.this._map.remove(this._transaction);
            if (session == null) {
                log.error("no session registered for transaction");
            } else if (status == 3) {
                session.flush();
            }
        }
    }
}

