/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.module.hibernate;

import at.molindo.esi4j.chain.Esi4JBatchedProcessingChain;
import at.molindo.esi4j.core.Esi4JIndex;
import at.molindo.esi4j.core.impl.AbstractIndexManager;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.module.hibernate.DefaultHibernateLifecycleInjector;
import at.molindo.esi4j.module.hibernate.HibernateLifecycleInjector;
import at.molindo.esi4j.module.hibernate.HibernateModule;
import at.molindo.esi4j.module.hibernate.scrolling.CustomQueryScrollingSessionProvider;
import at.molindo.esi4j.module.hibernate.scrolling.QueryProvider;
import at.molindo.esi4j.module.hibernate.scrolling.ScrollingSessionProvider;
import at.molindo.esi4j.module.hibernate.scrolling.SimpleQueryProvider;
import at.molindo.esi4j.rebuild.Esi4JRebuildManager;
import at.molindo.esi4j.rebuild.impl.DefaultRebuildManager;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;

public class HibernateIndexManager
extends AbstractIndexManager {
    private final HibernateLifecycleInjector _lifecycleInjector = new DefaultHibernateLifecycleInjector(false);

    public HibernateIndexManager(SessionFactory sessionFactory, Esi4JIndex index, Esi4JBatchedProcessingChain processingChain) {
        this(sessionFactory, index, processingChain, (Esi4JRebuildManager)new DefaultRebuildManager());
    }

    public HibernateIndexManager(SessionFactory sessionFactory, Esi4JIndex index, Esi4JBatchedProcessingChain processingChain, Esi4JRebuildManager rebuildManager) {
        super(new HibernateModule(sessionFactory), (InternalIndex)index, processingChain, rebuildManager);
        this._lifecycleInjector.injectLifecycle(sessionFactory, this.getBatchedProcessingChain().getEventProcessor());
    }

    @Override
    protected void onBeforeClose() {
        SessionFactory sessionFactory = this.getHibernateModule().getSessionFactory();
        if (sessionFactory != null) {
            this._lifecycleInjector.removeLifecycle(sessionFactory);
        }
    }

    private Esi4JBatchedProcessingChain getBatchedProcessingChain() {
        return (Esi4JBatchedProcessingChain)this.getProcessingChain();
    }

    private HibernateModule getHibernateModule() {
        return (HibernateModule)this.getModule();
    }

    public HibernateIndexManager query(Class<?> type, String hql, boolean ordered) {
        return this.queryProvider(type, new SimpleQueryProvider(hql, ordered));
    }

    public HibernateIndexManager criteria(Class<?> type, DetachedCriteria criteria, boolean ordered) {
        return this.queryProvider(type, new SimpleQueryProvider(criteria, ordered));
    }

    public HibernateIndexManager queryProvider(Class<?> type, QueryProvider queryProvider) {
        this.scrollingProvider(new CustomQueryScrollingSessionProvider(type, queryProvider));
        return this;
    }

    public HibernateIndexManager scrollingProvider(ScrollingSessionProvider scrollingProvider) {
        this.getHibernateModule().putScrollingProvider(scrollingProvider);
        return this;
    }
}

