/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.module.hibernate;

import at.molindo.esi4j.module.Esi4JModule;
import at.molindo.esi4j.module.hibernate.HibernateRebuildSession;
import at.molindo.esi4j.module.hibernate.scrolling.DefaultQueryScrollingSession;
import at.molindo.esi4j.module.hibernate.scrolling.ScrollingSession;
import at.molindo.esi4j.module.hibernate.scrolling.ScrollingSessionProvider;
import at.molindo.esi4j.rebuild.Esi4JRebuildSession;
import at.molindo.thirdparty.org.compass.core.util.concurrent.ConcurrentHashSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.EntityMode;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateModule
implements Esi4JModule {
    private static final Logger log = LoggerFactory.getLogger(HibernateModule.class);
    private final SessionFactory _sessionFactory;
    private final ConcurrentHashSet<Class<?>> _rebuilding = new ConcurrentHashSet();
    private final List<Class<?>> _types;
    private final ConcurrentMap<Class<?>, ScrollingSessionProvider> _scrollingProviders = Maps.newConcurrentMap();

    public HibernateModule(SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            throw new NullPointerException("sessionFactory");
        }
        this._sessionFactory = sessionFactory;
        ArrayList list = Lists.newArrayList();
        for (ClassMetadata classMetadata : sessionFactory.getAllClassMetadata().values()) {
            Class type = classMetadata.getMappedClass(EntityMode.POJO);
            if (type == null) continue;
            list.add(type);
        }
        this._types = Collections.unmodifiableList(list);
    }

    @Override
    public Esi4JRebuildSession startRebuildSession(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (!this._rebuilding.add(type)) {
            throw new IllegalStateException("already indexing " + type.getName());
        }
        return new HibernateRebuildSession(type, this._sessionFactory, this, this.newScrollingSession(type));
    }

    private ScrollingSession newScrollingSession(Class<?> type) {
        ScrollingSessionProvider scrollingSessionProvider = (ScrollingSessionProvider)this._scrollingProviders.get(type);
        return scrollingSessionProvider == null ? new DefaultQueryScrollingSession(type) : scrollingSessionProvider.newScrollingSession();
    }

    void unsetRebuilding(Class<?> type) {
        if (!this._rebuilding.remove(type)) {
            log.warn("type " + type.getName() + " not currently indexing");
        }
    }

    public void putScrollingProvider(ScrollingSessionProvider scrollingProvider) {
        if (scrollingProvider == null) {
            throw new NullPointerException("scrollingProvider");
        }
        this._scrollingProviders.put(scrollingProvider.getType(), scrollingProvider);
    }

    @Override
    public Class<?>[] getTypes() {
        return this._types.toArray(new Class[this._types.size()]);
    }

    @Override
    public void close() {
    }

    public SessionFactory getSessionFactory() {
        return this._sessionFactory;
    }
}

