/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.module.hibernate;

import at.molindo.esi4j.module.hibernate.HibernateModule;
import at.molindo.esi4j.module.hibernate.scrolling.ScrollingSession;
import at.molindo.esi4j.rebuild.Esi4JRebuildSession;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public final class HibernateRebuildSession
implements Esi4JRebuildSession {
    private final Transaction _tx;
    private final Session _session;
    private final Class<?> _type;
    private final HibernateModule _module;
    private final ScrollingSession _scrollingSession;

    public HibernateRebuildSession(Class<?> type, SessionFactory sessionFactory, HibernateModule module, ScrollingSession scrollingSession) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (sessionFactory == null) {
            throw new NullPointerException("sessionFactory");
        }
        if (module == null) {
            throw new NullPointerException("module");
        }
        this._type = type;
        this._module = module;
        this._scrollingSession = scrollingSession;
        this._session = sessionFactory.openSession();
        this._session.setCacheMode(CacheMode.GET);
        this._session.setDefaultReadOnly(true);
        this._session.setFlushMode(FlushMode.MANUAL);
        this._tx = this._session.beginTransaction();
    }

    @Override
    public boolean isOrdered() {
        return this._scrollingSession.isOrdered();
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    @Override
    public List<?> getNext(int batchSize) {
        this._session.clear();
        return this._scrollingSession.fetch((org.hibernate.Session)this._session, batchSize);
    }

    @Override
    public void close() {
        this._session.clear();
        this._module.unsetRebuilding(this._type);
        this._tx.commit();
        this._session.close();
    }
}

