/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.module.hibernate.scrolling;

import at.molindo.esi4j.module.hibernate.scrolling.QueryProvider;
import at.molindo.esi4j.module.hibernate.scrolling.ScrollingSession;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;

public class CustomQueryScrollingSession
implements ScrollingSession {
    private final QueryProvider _queryProvider;
    private int _next = 0;
    private final Class<?> _type;

    public CustomQueryScrollingSession(Class<?> type, QueryProvider queryProvider) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (queryProvider == null) {
            throw new NullPointerException("queryProvider");
        }
        this._type = type;
        this._queryProvider = queryProvider;
    }

    @Override
    public boolean isOrdered() {
        return this._queryProvider.isOrdered();
    }

    @Override
    public List<?> fetch(Session session, int batchSize) {
        List<?> list;
        Criteria criteria = this._queryProvider.createCriteria(this._type, session);
        if (criteria != null) {
            list = this.fetch(criteria, this._next, batchSize);
        } else {
            Query query = this._queryProvider.createQuery(this._type, session);
            list = this.fetch(query, this._next, batchSize);
        }
        this._next += list.size();
        return list;
    }

    private List<?> fetch(Criteria criteria, int first, int max) {
        return criteria.setFirstResult(first).setMaxResults(max).setCacheable(false).list();
    }

    private List<?> fetch(Query query, int first, int max) {
        return query.setFirstResult(first).setMaxResults(max).setCacheable(false).list();
    }
}

