/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.module.hibernate.scrolling;

import at.molindo.esi4j.module.hibernate.scrolling.ScrollingSession;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.SessionImpl;
import org.hibernate.metadata.ClassMetadata;

public class DefaultQueryScrollingSession
implements ScrollingSession {
    private final Class<?> _type;
    private Serializable _lastId;
    private Map<String, FetchMode> _fetchModes;

    public DefaultQueryScrollingSession(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this._type = type;
        this._fetchModes = Collections.emptyMap();
    }

    public DefaultQueryScrollingSession(Class<?> type, Map<String, FetchMode> fetchModes) {
        this(type);
        this._fetchModes = new HashMap<String, FetchMode>(fetchModes);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public List<?> fetch(Session session, int batchSize) {
        Criteria criteria = session.createCriteria(this._type);
        if (this._lastId != null) {
            criteria.add((Criterion)Restrictions.gt((String)"id", (Object)this._lastId));
        }
        criteria.addOrder(Order.asc((String)"id"));
        criteria.setMaxResults(batchSize);
        criteria.setCacheable(false);
        for (Map.Entry<String, FetchMode> e : this._fetchModes.entrySet()) {
            criteria.setFetchMode(e.getKey(), e.getValue());
        }
        List list = criteria.list();
        if (list.size() > 0) {
            ClassMetadata meta = session.getSessionFactory().getClassMetadata(this._type);
            Object last = list.get(list.size() - 1);
            this._lastId = meta.getIdentifier(last, (SessionImplementor)((SessionImpl)session));
        }
        return list;
    }
}

