/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.multi.impl;

import at.molindo.esi4j.core.Esi4JIndex;
import at.molindo.esi4j.core.Esi4JIndexManager;
import at.molindo.esi4j.core.impl.AbstractIndex;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.mapping.TypeMapping;
import at.molindo.esi4j.multi.Esi4JManagedMultiIndex;
import at.molindo.esi4j.multi.Esi4JMultiStore;
import at.molindo.esi4j.multi.impl.DefaultMultiIndexManager;
import at.molindo.esi4j.multi.impl.DefaultMultiStore;
import at.molindo.utils.data.StringUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class DefaultManagedMultiIndex
extends AbstractIndex
implements Esi4JManagedMultiIndex {
    private final String _name;
    private final LinkedHashMap<String, InternalIndex> _indices = Maps.newLinkedHashMap();
    private Esi4JIndexManager _indexManager;
    private final Esi4JMultiStore _store;

    public DefaultManagedMultiIndex(Iterable<? extends InternalIndex> indices) {
        for (InternalIndex internalIndex : indices) {
            this._indices.put(internalIndex.getName(), internalIndex);
        }
        if (this._indices.size() == 0) {
            throw new IllegalArgumentException("at least one index required");
        }
        this._name = StringUtils.join((String)",", this._indices.keySet());
        this._store = new DefaultMultiStore(this);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isMapped(Class<?> type) {
        for (InternalIndex index : this._indices.values()) {
            if (!index.isMapped(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMapped(Object o) {
        for (InternalIndex index : this._indices.values()) {
            if (!index.isMapped(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String findIndexName(Class<?> type) {
        Esi4JIndex mappedIndex = null;
        for (InternalIndex index : this._indices.values()) {
            if (!index.isMapped(type)) continue;
            if (mappedIndex != null) {
                throw new IllegalArgumentException("can't find index for type mapped on multiple indices: " + type.getName());
            }
            mappedIndex = index;
        }
        if (mappedIndex == null) {
            throw new IllegalArgumentException("unmapped type " + type.getName() + " for index " + this.getName());
        }
        return mappedIndex.getName();
    }

    @Override
    public TypeMapping findTypeMapping(Object o) {
        for (InternalIndex index : this._indices.values()) {
            if (!index.isMapped(o)) continue;
            return index.findTypeMapping(o);
        }
        throw new IllegalArgumentException("type not mapped: " + o.getClass().getName());
    }

    @Override
    public TypeMapping findTypeMapping(Class<?> type) {
        for (InternalIndex index : this._indices.values()) {
            if (!index.isMapped(type)) continue;
            return index.findTypeMapping(type);
        }
        throw new IllegalArgumentException("type not mapped: " + type.getName());
    }

    @Override
    public TypeMapping findTypeMapping(String indexName, String typeAlias) {
        for (InternalIndex index : this._indices.values()) {
            if (!index.getStore().getIndexName().equals(indexName)) continue;
            return index.findTypeMapping(indexName, typeAlias);
        }
        throw new IllegalArgumentException("unexpected indexName: " + indexName);
    }

    @Override
    public Class<?>[] getMappedTypes() {
        LinkedHashSet types = Sets.newLinkedHashSet();
        for (InternalIndex index : this._indices.values()) {
            types.addAll(Arrays.asList(index.getMappedTypes()));
        }
        return types.toArray(new Class[types.size()]);
    }

    @Override
    public Map<String, InternalIndex> getIndices() {
        return Collections.unmodifiableMap(this._indices);
    }

    @Override
    protected Esi4JMultiStore getStore() {
        return this._store;
    }

    @Override
    public void setIndexManager(Esi4JIndexManager indexManager) {
        throw new IllegalStateException("index contains index manager by default");
    }

    @Override
    public Esi4JIndexManager getIndexManager() {
        if (this._indexManager == null) {
            this._indexManager = new DefaultMultiIndexManager(this);
        }
        return this._indexManager;
    }
}

