/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.multi.impl;

import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.multi.Esi4JManagedMultiIndex;
import at.molindo.esi4j.multi.Esi4JMultiIndexManager;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;

public class DefaultMultiIndexManager
implements Esi4JMultiIndexManager {
    private final Esi4JManagedMultiIndex _index;

    public DefaultMultiIndexManager(Esi4JManagedMultiIndex index) {
        if (index == null) {
            throw new NullPointerException("index");
        }
        this._index = index;
    }

    @Override
    public void rebuild(Class<?> ... types) {
        for (InternalIndex index : this.getIndex().getIndices().values()) {
            LinkedHashSet typeSet = Sets.newLinkedHashSet(Arrays.asList(types));
            typeSet.retainAll(Arrays.asList(index.getIndexManager().getTypes()));
            Class[] managedTypes = typeSet.toArray(new Class[typeSet.size()]);
            index.getIndexManager().rebuild(managedTypes);
        }
    }

    @Override
    public void refresh() {
        for (Map.Entry<String, InternalIndex> e : this._index.getIndices().entrySet()) {
            e.getValue().getIndexManager().refresh();
        }
    }

    @Override
    public Class<?>[] getTypes() {
        LinkedHashSet types = Sets.newLinkedHashSet();
        for (InternalIndex index : this.getIndex().getIndices().values()) {
            types.addAll(Arrays.asList(index.getIndexManager().getTypes()));
        }
        return types.toArray(new Class[types.size()]);
    }

    @Override
    public Esi4JManagedMultiIndex getIndex() {
        return this._index;
    }

    @Override
    public void close() {
    }
}

