/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.multi.impl;

import at.molindo.esi4j.core.Esi4JClient;
import at.molindo.esi4j.core.Esi4JIndex;
import at.molindo.esi4j.core.Esi4JStore;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.multi.Esi4JManagedMultiIndex;
import at.molindo.esi4j.multi.Esi4JMultiStore;
import java.util.Iterator;

public class DefaultMultiStore
implements Esi4JMultiStore {
    private final Esi4JManagedMultiIndex _index;
    private final Iterable<Esi4JStore> _stores;

    public DefaultMultiStore(Esi4JManagedMultiIndex index) {
        if (index == null) {
            throw new NullPointerException("index");
        }
        this._index = index;
        this._stores = new Iterable<Esi4JStore>(){

            @Override
            public Iterator<Esi4JStore> iterator() {
                return DefaultMultiStore.this.gestStoresIterator();
            }
        };
    }

    @Override
    public String getIndexName() {
        StringBuilder buf = new StringBuilder();
        for (Esi4JStore store : this._stores) {
            buf.append(store.getIndexName()).append(",");
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }

    @Override
    public <T> T execute(Esi4JStore.StoreOperation<T> operation) {
        return operation.execute(this.getClient().getClient(), this.getIndexName());
    }

    @Override
    public void setIndex(Esi4JIndex index) {
        throw new IllegalStateException("store was already assigned to an index named " + index.getName());
    }

    @Override
    public Esi4JClient getClient() {
        Esi4JClient client = null;
        for (Esi4JStore store : this._stores) {
            if (client == null) {
                client = store.getClient();
                continue;
            }
            if (client.getClusterName().equals(store.getClient().getClusterName())) continue;
            throw new IllegalArgumentException("can't create store among multiple clusters");
        }
        return client;
    }

    @Override
    public Iterable<Esi4JStore> getStores() {
        return this._stores;
    }

    private Iterator<Esi4JStore> gestStoresIterator() {
        return new Iterator<Esi4JStore>(){
            private final Iterator<InternalIndex> _iter;
            {
                this._iter = DefaultMultiStore.this._index.getIndices().values().iterator();
            }

            @Override
            public Esi4JStore next() {
                return this._iter.next().getStore();
            }

            @Override
            public boolean hasNext() {
                return this._iter.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() {
    }
}

