/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.rebuild.impl;

import at.molindo.esi4j.core.Esi4JOperation;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.module.Esi4JModule;
import at.molindo.esi4j.rebuild.Esi4JRebuildManager;
import at.molindo.esi4j.rebuild.Esi4JRebuildProcessor;
import at.molindo.esi4j.rebuild.Esi4JRebuildSession;
import at.molindo.esi4j.rebuild.scrutineer.ScrutineerRebuildProcessor;
import at.molindo.esi4j.rebuild.simple.SimpleRebuildProcessor;
import at.molindo.utils.collections.ArrayUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;

public class DefaultRebuildManager
implements Esi4JRebuildManager {
    private final List<Esi4JRebuildProcessor> _processors;
    private TimeValue _healthTimeout = TimeValue.timeValueSeconds((long)60L);

    public DefaultRebuildManager() {
        this(new ScrutineerRebuildProcessor(), new SimpleRebuildProcessor());
    }

    public DefaultRebuildManager(Esi4JRebuildProcessor ... processors) {
        if (ArrayUtils.empty((Object[])processors)) {
            throw new IllegalArgumentException("processors must not be empty");
        }
        this._processors = Lists.newArrayList((Object[])processors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuild(Esi4JModule module, InternalIndex index, Class<?> ... types) {
        for (Class<?> type : types) {
            index.findTypeMapping(type);
        }
        for (Class<?> type : types) {
            Esi4JRebuildSession rebuildSession = module.startRebuildSession(type);
            try {
                this.waitForGreenStatus(index);
                this.findRebuildProcessor(rebuildSession).rebuild(index, rebuildSession);
            }
            finally {
                rebuildSession.close();
            }
        }
        index.execute(new Esi4JOperation<Void>(){

            @Override
            public Void execute(Client client, String indexName, Esi4JOperation.OperationContext context) {
                client.admin().indices().prepareOptimize(new String[]{indexName}).execute().actionGet();
                return null;
            }
        });
    }

    private void waitForGreenStatus(InternalIndex index) {
        if (this._healthTimeout != null && this._healthTimeout.seconds() > 0L) {
            index.execute(new Esi4JOperation<Void>(){

                @Override
                public Void execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
                    ClusterHealthRequestBuilder request = client.admin().cluster().prepareHealth(new String[]{indexName});
                    request.setWaitForGreenStatus().setTimeout(DefaultRebuildManager.this._healthTimeout);
                    ClusterHealthResponse response = (ClusterHealthResponse)request.execute().actionGet();
                    if (response.getStatus() != ClusterHealthStatus.GREEN) {
                        throw new IllegalStateException("cluster not ready for rebuild (status " + response.getStatus() + ")");
                    }
                    return null;
                }
            });
        }
    }

    private Esi4JRebuildProcessor findRebuildProcessor(Esi4JRebuildSession rebuildSession) {
        for (Esi4JRebuildProcessor processor : this._processors) {
            if (!processor.isSupported(rebuildSession)) continue;
            return processor;
        }
        throw new IllegalArgumentException("session for type " + rebuildSession.getType() + " not supported by any processor");
    }

    @Override
    public void close() {
    }

    public TimeValue getHealthTimeout() {
        return this._healthTimeout;
    }

    public DefaultRebuildManager setHealthTimeout(TimeValue healthTimeout) {
        this._healthTimeout = healthTimeout;
        return this;
    }
}

