/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.rebuild.scrutineer;

import com.aconex.scrutineer.IdAndVersion;
import com.aconex.scrutineer.IdAndVersionStream;
import com.aconex.scrutineer.IdAndVersionStreamVerifierListener;
import com.aconex.scrutineer.LogUtils;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class IdAndVersionStreamVerifier {
    private static final Logger LOG = LogUtils.loggerForThisClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify(IdAndVersionStream primaryStream, IdAndVersionStream secondayStream, IdAndVersionStreamVerifierListener idAndVersionStreamVerifierListener) {
        long numItems = 0L;
        long begin = System.currentTimeMillis();
        try {
            this.parallelOpenStreamsAndWait(primaryStream, secondayStream);
            Iterator primaryIterator = primaryStream.iterator();
            Iterator secondaryIterator = secondayStream.iterator();
            IdAndVersion primaryItem = this.next(primaryIterator);
            IdAndVersion secondaryItem = this.next(secondaryIterator);
            while (primaryItem != null && secondaryItem != null) {
                if (primaryItem.equals(secondaryItem)) {
                    primaryItem = this.verifiedNext(primaryIterator, primaryItem);
                    secondaryItem = this.next(secondaryIterator);
                } else if (primaryItem.getId().equals(secondaryItem.getId())) {
                    idAndVersionStreamVerifierListener.onVersionMisMatch(primaryItem, secondaryItem);
                    primaryItem = this.verifiedNext(primaryIterator, primaryItem);
                    secondaryItem = this.next(secondaryIterator);
                } else if (primaryItem.compareTo((Object)secondaryItem) < 0) {
                    idAndVersionStreamVerifierListener.onMissingInSecondaryStream(primaryItem);
                    primaryItem = this.verifiedNext(primaryIterator, primaryItem);
                } else {
                    idAndVersionStreamVerifierListener.onMissingInPrimaryStream(secondaryItem);
                    secondaryItem = this.next(secondaryIterator);
                }
                ++numItems;
            }
            while (primaryItem != null) {
                idAndVersionStreamVerifierListener.onMissingInSecondaryStream(primaryItem);
                primaryItem = this.verifiedNext(primaryIterator, primaryItem);
                ++numItems;
            }
            while (secondaryItem != null) {
                idAndVersionStreamVerifierListener.onMissingInPrimaryStream(secondaryItem);
                secondaryItem = this.next(secondaryIterator);
                ++numItems;
            }
        }
        finally {
            this.closeWithoutThrowingException(primaryStream);
            this.closeWithoutThrowingException(secondayStream);
        }
        LogUtils.infoTimeTaken((Logger)LOG, (long)begin, (long)numItems, (String)"Completed verification", (Object[])new Object[0]);
    }

    private void parallelOpenStreamsAndWait(IdAndVersionStream primaryStream, IdAndVersionStream secondaryStream) {
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            Future<?> secondaryStreamFuture = executorService.submit(new OpenStreamRunner(secondaryStream));
            primaryStream.open();
            secondaryStreamFuture.get();
            executorService.shutdown();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to open one or both of the streams in parallel", e);
        }
    }

    private IdAndVersion verifiedNext(Iterator<IdAndVersion> iterator, IdAndVersion previous) {
        if (iterator.hasNext()) {
            IdAndVersion next = iterator.next();
            if (next == null) {
                throw new IllegalStateException("primary stream must not return null");
            }
            if (previous.compareTo((Object)next) > 0) {
                throw new IllegalStateException("primary stream not ordered as expected: " + next + " followed " + previous);
            }
            return next;
        }
        return null;
    }

    private IdAndVersion next(Iterator<IdAndVersion> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private void closeWithoutThrowingException(IdAndVersionStream idAndVersionStream) {
        try {
            idAndVersionStream.close();
        }
        catch (Exception e) {
            LogUtils.warn((Logger)LOG, (String)"Unable to close IdAndVersionStream", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private static class OpenStreamRunner
    implements Runnable {
        private final IdAndVersionStream primaryStream;

        public OpenStreamRunner(IdAndVersionStream primaryStream) {
            this.primaryStream = primaryStream;
        }

        @Override
        public void run() {
            this.primaryStream.open();
        }
    }
}

