/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.rebuild.scrutineer;

import at.molindo.esi4j.mapping.TypeMapping;
import at.molindo.esi4j.rebuild.Esi4JRebuildSession;
import at.molindo.esi4j.rebuild.scrutineer.ObjectIdAndVersion;
import com.aconex.scrutineer.IdAndVersion;
import com.aconex.scrutineer.IdAndVersionStream;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class ModuleIdAndVersionStream
implements IdAndVersionStream {
    private final int _batchSize;
    private final TypeMapping _mapping;
    private Esi4JRebuildSession _rebuildSession;

    public ModuleIdAndVersionStream(Esi4JRebuildSession rebuildSession, int batchSize, TypeMapping mapping) {
        this._rebuildSession = rebuildSession;
        this._batchSize = batchSize;
        this._mapping = mapping;
    }

    public void open() {
    }

    public Iterator<IdAndVersion> iterator() {
        this.verifyOpen();
        return new ModuleIdAndVersionStreamIterator();
    }

    public void close() {
        this._rebuildSession = null;
    }

    private void verifyOpen() {
        if (this._rebuildSession == null) {
            throw new IllegalStateException("stream not open");
        }
    }

    final class ModuleIdAndVersionStreamIterator
    implements Iterator<IdAndVersion> {
        private Iterator<?> _iter;
        private Object _next;
        private boolean _lastBatchFetched = false;

        private ModuleIdAndVersionStreamIterator() {
            this.fetchBatch();
        }

        private void findNext() {
            while (this._next == null && this._iter != null) {
                if (!this._iter.hasNext()) {
                    this.fetchBatch();
                }
                if (this._iter.hasNext()) {
                    this._next = this._iter.next();
                    if (!ModuleIdAndVersionStream.this._mapping.isFiltered(this._next)) continue;
                    this._next = null;
                    continue;
                }
                if (!this._lastBatchFetched) continue;
                this._iter = null;
                break;
            }
        }

        private void fetchBatch() {
            ModuleIdAndVersionStream.this.verifyOpen();
            if (this._iter == null || !this._lastBatchFetched && !this._iter.hasNext()) {
                List<?> list = ModuleIdAndVersionStream.this._rebuildSession.getNext(ModuleIdAndVersionStream.this._batchSize);
                if (list.size() < ModuleIdAndVersionStream.this._batchSize) {
                    this._lastBatchFetched = true;
                }
                this._iter = list.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this._next != null;
        }

        @Override
        public IdAndVersion next() {
            this.findNext();
            if (this._next == null) {
                throw new NoSuchElementException();
            }
            Object next = this._next;
            this._next = null;
            Object id = ModuleIdAndVersionStream.this._mapping.getId(next);
            Long version = ModuleIdAndVersionStream.this._mapping.getVersion(next);
            if (version == null) {
                version = Long.MAX_VALUE;
            }
            if (!ObjectIdAndVersion.isIdSupported(id)) {
                id = ModuleIdAndVersionStream.this._mapping.toIdString(id);
            }
            return new ObjectIdAndVersion(id, version, next);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

