/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.rebuild.scrutineer;

import at.molindo.esi4j.core.Esi4JOperation;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.mapping.TypeMapping;
import at.molindo.esi4j.rebuild.Esi4JRebuildProcessor;
import at.molindo.esi4j.rebuild.Esi4JRebuildSession;
import at.molindo.esi4j.rebuild.scrutineer.IdAndVersionStreamVerifier;
import at.molindo.esi4j.rebuild.scrutineer.MappedObjectIdAndVersionFactory;
import at.molindo.esi4j.rebuild.scrutineer.ModuleIdAndVersionStream;
import at.molindo.esi4j.rebuild.scrutineer.VerifierListener;
import at.molindo.esi4j.rebuild.util.BulkIndexHelper;
import com.aconex.scrutineer.IdAndVersion;
import com.aconex.scrutineer.IdAndVersionFactory;
import com.aconex.scrutineer.IdAndVersionStream;
import com.aconex.scrutineer.IdAndVersionStreamVerifierListener;
import com.aconex.scrutineer.elasticsearch.ElasticSearchDownloader;
import com.aconex.scrutineer.elasticsearch.ElasticSearchIdAndVersionStream;
import com.aconex.scrutineer.elasticsearch.ElasticSearchSorter;
import com.aconex.scrutineer.elasticsearch.IdAndVersionDataReaderFactory;
import com.aconex.scrutineer.elasticsearch.IdAndVersionDataWriterFactory;
import com.aconex.scrutineer.elasticsearch.IteratorFactory;
import com.fasterxml.sort.DataReaderFactory;
import com.fasterxml.sort.DataWriterFactory;
import com.fasterxml.sort.SortConfig;
import com.fasterxml.sort.Sorter;
import com.fasterxml.sort.util.NaturalComparator;
import java.util.Comparator;
import org.apache.commons.lang.SystemUtils;
import org.elasticsearch.client.Client;

public class ScrutineerRebuildProcessor
implements Esi4JRebuildProcessor {
    private static final int DEFAULT_SORT_MEM = 0x10000000;
    private static final int DEFAULT_BATCH_SIZE = 1000;

    @Override
    public boolean isSupported(Esi4JRebuildSession rebuildSession) {
        return rebuildSession.isOrdered();
    }

    @Override
    public void rebuild(InternalIndex index, final Esi4JRebuildSession rebuildSession) {
        index.updateMapping(rebuildSession.getType());
        index.execute(new Esi4JOperation<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute(Client client, String indexName, Esi4JOperation.OperationContext context) {
                final TypeMapping mapping = context.findTypeMapping(rebuildSession.getType());
                ModuleIdAndVersionStream moduleStream = new ModuleIdAndVersionStream(rebuildSession, 1000, mapping);
                MappedObjectIdAndVersionFactory factory = new MappedObjectIdAndVersionFactory(mapping);
                ElasticSearchSorter elasticSearchSorter = new ElasticSearchSorter(ScrutineerRebuildProcessor.this.createSorter(factory));
                IteratorFactory iteratorFactory = new IteratorFactory((IdAndVersionFactory)factory);
                String workingDirectory = SystemUtils.getJavaIoTmpDir().getAbsolutePath();
                ElasticSearchIdAndVersionStream esStream = new ElasticSearchIdAndVersionStream(new ElasticSearchDownloader(client, indexName, "_type:" + mapping.getTypeAlias(), (IdAndVersionFactory)factory), elasticSearchSorter, iteratorFactory, workingDirectory);
                BulkIndexHelper bulkHelper = new BulkIndexHelper().setMaxRunning(2);
                bulkHelper.setResponseHandler(new BulkIndexHelper.IResponseHandler(){

                    @Override
                    public void handle(String id, String type) {
                        if ("delete".equals(type)) {
                            ScrutineerRebuildProcessor.this.onDelete(mapping.getTypeClass(), mapping.toId(id));
                        } else {
                            ScrutineerRebuildProcessor.this.onIndex(mapping.getTypeClass(), mapping.toId(id));
                        }
                    }
                });
                VerifierListener listener = new VerifierListener(client, indexName, context, mapping, bulkHelper, 1000);
                try {
                    ScrutineerRebuildProcessor.this.verify(moduleStream, (IdAndVersionStream)esStream, listener);
                }
                finally {
                    listener.close();
                }
                return null;
            }
        });
    }

    private Sorter<IdAndVersion> createSorter(IdAndVersionFactory factory) {
        SortConfig sortConfig = new SortConfig().withMaxMemoryUsage(0x10000000L);
        IdAndVersionDataReaderFactory dataReaderFactory = new IdAndVersionDataReaderFactory(factory);
        IdAndVersionDataWriterFactory dataWriterFactory = new IdAndVersionDataWriterFactory();
        return new Sorter(sortConfig, (DataReaderFactory)dataReaderFactory, (DataWriterFactory)dataWriterFactory, (Comparator)new NaturalComparator());
    }

    private void verify(IdAndVersionStream primaryStream, IdAndVersionStream secondaryStream, IdAndVersionStreamVerifierListener listener) {
        new IdAndVersionStreamVerifier().verify(primaryStream, secondaryStream, listener);
    }

    protected void onIndex(Class<?> type, Object id) {
    }

    protected void onDelete(Class<?> type, Object id) {
    }
}

