/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.rebuild.scrutineer;

import at.molindo.esi4j.core.Esi4JOperation;
import at.molindo.esi4j.mapping.TypeMapping;
import at.molindo.esi4j.rebuild.scrutineer.ObjectIdAndVersion;
import at.molindo.esi4j.rebuild.util.BulkIndexHelper;
import com.aconex.scrutineer.IdAndVersion;
import com.aconex.scrutineer.IdAndVersionStreamVerifierListener;
import org.elasticsearch.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifierListener
implements IdAndVersionStreamVerifierListener {
    private static final Logger log = LoggerFactory.getLogger(VerifierListener.class);
    private final TypeMapping _mapping;
    private final BulkIndexHelper.Session _bulkSession;
    private int _index;
    private int _update;
    private int _delete;

    public VerifierListener(Client client, String indexName, Esi4JOperation.OperationContext context, TypeMapping mapping, BulkIndexHelper bulkHelper, int batchSize) {
        this._mapping = mapping;
        this._bulkSession = bulkHelper.newSession(client, indexName, context, batchSize);
    }

    public void onMissingInSecondaryStream(IdAndVersion primaryItem) {
        ++this._index;
        this.index((ObjectIdAndVersion)primaryItem);
    }

    public void onVersionMisMatch(IdAndVersion primaryItem, IdAndVersion secondaryItem) {
        ++this._update;
        this.index((ObjectIdAndVersion)primaryItem);
    }

    public void onMissingInPrimaryStream(IdAndVersion secondaryItem) {
        ++this._delete;
        this.delete(secondaryItem);
    }

    private void index(ObjectIdAndVersion objectIdAndVersion) {
        this._bulkSession.index(objectIdAndVersion.getObject());
    }

    private void delete(IdAndVersion idAndVersion) {
        this._bulkSession.delete(this._mapping.getTypeClass(), this._mapping.toId(idAndVersion.getId()), idAndVersion.getVersion());
    }

    public void close() {
        this._bulkSession.submit();
        log.info("submitted " + (this._index + this._update + this._delete) + " requests (" + this._index + " index, " + this._update + " update, " + this._delete + " delete)");
    }
}

