/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.rebuild.simple;

import at.molindo.esi4j.core.Esi4JOperation;
import at.molindo.esi4j.core.internal.InternalIndex;
import at.molindo.esi4j.mapping.TypeMapping;
import at.molindo.esi4j.rebuild.Esi4JRebuildProcessor;
import at.molindo.esi4j.rebuild.Esi4JRebuildSession;
import at.molindo.esi4j.rebuild.util.BulkIndexHelper;
import java.util.List;
import org.elasticsearch.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRebuildProcessor
implements Esi4JRebuildProcessor {
    private static final Logger log = LoggerFactory.getLogger(SimpleRebuildProcessor.class);
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final int DEFAULT_MAX_RUNNING = 10;
    private int _batchSize = 1000;
    private int _maxRunning = 10;

    public SimpleRebuildProcessor() {
    }

    public SimpleRebuildProcessor(int batchSize) {
        this.setBatchSize(batchSize);
    }

    @Override
    public boolean isSupported(Esi4JRebuildSession rebuildSession) {
        return true;
    }

    @Override
    public void rebuild(InternalIndex index, Esi4JRebuildSession rebuildSession) {
        final Class<?> type = rebuildSession.getType();
        log.info("rebuilding index for object of type " + type.getName());
        long start = System.currentTimeMillis();
        index.execute(new Esi4JOperation<Void>(){

            @Override
            public Void execute(Client client, String indexName, Esi4JOperation.OperationContext context) {
                TypeMapping mapping = context.findTypeMapping(type);
                client.admin().indices().prepareDeleteMapping(new String[]{indexName}).setType(mapping.getTypeAlias()).execute().actionGet();
                return null;
            }
        });
        index.updateMapping(type);
        try {
            List<?> list;
            BulkIndexHelper h = new BulkIndexHelper().setMaxRunning(this.getMaxRunning());
            while ((list = rebuildSession.getNext(this._batchSize)).size() > 0) {
                h.bulkIndex(index, list);
            }
            h.await();
            long seconds = (System.currentTimeMillis() - start) / 1000L;
            StringBuilder logMsg = new StringBuilder("finished indexing of ").append(h.getSucceeded()).append(" objects of type ").append(type.getName()).append(" in ").append(seconds).append(" seconds");
            if (h.getFailed() > 0) {
                logMsg.append(" (").append(h.getFailed()).append(" failed)");
                log.warn(logMsg.toString());
            } else {
                log.info(logMsg.toString());
            }
        }
        catch (InterruptedException e) {
            log.error("awaiting completion of indexing has been interrupted", (Throwable)e);
        }
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public SimpleRebuildProcessor setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be > 0, was " + batchSize);
        }
        this._batchSize = batchSize;
        return this;
    }

    public int getMaxRunning() {
        return this._maxRunning;
    }

    public SimpleRebuildProcessor setMaxRunning(int maxRunning) {
        if (maxRunning <= 0) {
            throw new IllegalArgumentException("maxRunning must be > 0, was " + maxRunning);
        }
        this._maxRunning = maxRunning;
        return this;
    }
}

