/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.rebuild.util;

import at.molindo.esi4j.core.Esi4JIndex;
import at.molindo.esi4j.core.Esi4JOperation;
import at.molindo.esi4j.mapping.TypeMapping;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkIndexHelper {
    private static final Logger log = LoggerFactory.getLogger(BulkIndexHelper.class);
    private static final int DEFAULT_MAX_RUNNING = 2;
    private final ReentrantLock _lock = new ReentrantLock();
    private final Condition _allCompleted = this._lock.newCondition();
    private final Condition _nextCompleted = this._lock.newCondition();
    private int _maxRunning = 2;
    private int _running = 0;
    private int _succeeded = 0;
    private int _failed = 0;
    private IResponseHandler _responseHandler;

    public Session newSession(Esi4JIndex index, final int batchSize) {
        return index.execute(new Esi4JOperation<Session>(){

            @Override
            public Session execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
                return BulkIndexHelper.this.newSession(client, indexName, helper, batchSize);
            }
        });
    }

    public Session newSession(Client client, String indexName, Esi4JOperation.OperationContext context, int batchSize) {
        return new Session(client, indexName, context, batchSize);
    }

    public void bulkIndex(Esi4JIndex index, List<?> list) {
        Session session = this.newSession(index, list.size());
        for (Object o : list) {
            session.index(o);
        }
        session.submit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkIndex(BulkRequestBuilder request) {
        final int items = request.numberOfActions();
        if (items == 0) {
            return;
        }
        this._lock.lock();
        try {
            while (this._running >= this._maxRunning) {
                try {
                    this._nextCompleted.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("waiting interrupted", e);
                }
            }
            ++this._running;
        }
        finally {
            this._lock.unlock();
        }
        request.execute((ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse response) {
                int succeeded = 0;
                int failed = 0;
                BulkItemResponse[] items2 = response.getItems();
                for (int i = 0; i < items2.length; ++i) {
                    BulkItemResponse item = items2[i];
                    if (item.isFailed()) {
                        ++failed;
                        continue;
                    }
                    ++succeeded;
                    if (BulkIndexHelper.this._responseHandler == null) continue;
                    BulkIndexHelper.this._responseHandler.handle(item.getId(), item.getOpType());
                }
                this.end(succeeded, failed);
            }

            public void onFailure(Throwable e) {
                log.warn("failed to bulk index", e);
                this.end(0, items);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void end(int succeeded, int failed) {
                BulkIndexHelper.this._lock.lock();
                try {
                    BulkIndexHelper.this._failed += failed;
                    BulkIndexHelper.this._succeeded += succeeded;
                    BulkIndexHelper.this._nextCompleted.signal();
                    if (--BulkIndexHelper.this._running == 0) {
                        BulkIndexHelper.this._allCompleted.signal();
                    }
                }
                finally {
                    BulkIndexHelper.this._lock.unlock();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        this._lock.lock();
        try {
            while (this._running > 0) {
                this._allCompleted.await();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSucceeded() {
        this._lock.lock();
        try {
            int n = this._succeeded;
            return n;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFailed() {
        this._lock.lock();
        try {
            int n = this._failed;
            return n;
        }
        finally {
            this._lock.unlock();
        }
    }

    public int getMaxRunning() {
        return this._maxRunning;
    }

    public BulkIndexHelper setMaxRunning(int maxRunning) {
        if (maxRunning <= 0) {
            throw new IllegalArgumentException("maxRunning must be > 0, was " + maxRunning);
        }
        this._maxRunning = maxRunning;
        return this;
    }

    public BulkIndexHelper setResponseHandler(IResponseHandler responseHandler) {
        this._responseHandler = responseHandler;
        return this;
    }

    public class Session {
        private final Client _client;
        private final String _indexName;
        private final Esi4JOperation.OperationContext _context;
        private final int _batchSize;
        private final List<ActionRequestBuilder<?, ?, ?>> _requests;

        public Session(Client client, String indexName, Esi4JOperation.OperationContext context, int batchSize) {
            this._client = client;
            this._indexName = indexName;
            this._context = context;
            this._batchSize = batchSize;
            this._requests = Lists.newArrayListWithCapacity((int)this._batchSize);
        }

        public Session index(Object o) {
            this.add((ActionRequestBuilder<?, ?, ?>)this.toIndexRequest(o));
            return this;
        }

        public IndexRequestBuilder toIndexRequest(Object object) {
            TypeMapping mapping = this._context.findTypeMapping(object);
            return mapping.indexRequest(this._client, this._indexName, object);
        }

        public Session delete(Object o) {
            TypeMapping mapping = this._context.findTypeMapping(o);
            this.delete(mapping.getTypeClass(), mapping.getId(o), mapping.getVersion(o));
            return this;
        }

        public Session delete(Class<?> type, Object id, Long version) {
            this.add((ActionRequestBuilder<?, ?, ?>)this.toDeleteRequest(type, id, version));
            return this;
        }

        private DeleteRequestBuilder toDeleteRequest(Class<?> type, Object id, Long version) {
            TypeMapping mapping = this._context.findTypeMapping(type);
            return mapping.deleteRequest(this._client, this._indexName, mapping.toIdString(id), version);
        }

        private void add(ActionRequestBuilder<?, ?, ?> request) {
            this._requests.add(request);
            if (this._requests.size() == this._batchSize) {
                this.submit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BulkIndexHelper submit() {
            try {
                BulkIndexHelper.this.bulkIndex(new Esi4JOperation<BulkRequestBuilder>(){

                    @Override
                    public BulkRequestBuilder execute(Client client, String indexName, Esi4JOperation.OperationContext helper) {
                        BulkRequestBuilder bulk = client.prepareBulk();
                        for (ActionRequestBuilder request : Session.this._requests) {
                            if (request instanceof IndexRequestBuilder) {
                                bulk.add((IndexRequestBuilder)request);
                                continue;
                            }
                            if (request instanceof DeleteRequestBuilder) {
                                bulk.add((DeleteRequestBuilder)request);
                                continue;
                            }
                            if (request == null) continue;
                            throw new IllegalArgumentException("unexpected request type " + request.getClass().getName());
                        }
                        return bulk;
                    }
                }.execute(this._client, this._indexName, this._context));
            }
            finally {
                this._requests.clear();
            }
            return BulkIndexHelper.this;
        }
    }

    public static interface IResponseHandler {
        public void handle(String var1, String var2);
    }
}

