/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.rebuild.util;

import at.molindo.esi4j.rebuild.Esi4JRebuildSession;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IteratorRebuildSession
implements Esi4JRebuildSession {
    private final Class<?> _type;
    private Iterator<?> _iterator;
    private final boolean _ordered;

    public IteratorRebuildSession(Class<?> type, Iterator<?> iterator, boolean ordered) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this._type = type;
        this._iterator = iterator;
        this._ordered = ordered;
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    @Override
    public boolean isOrdered() {
        return this._ordered;
    }

    @Override
    public List<?> getNext(int batchSize) {
        if (this._iterator == null) {
            throw new IllegalStateException("already closed");
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)batchSize);
        while (list.size() < batchSize && this._iterator.hasNext()) {
            list.add(this._iterator.next());
        }
        return list;
    }

    @Override
    public void close() {
        this._iterator = null;
    }
}

