/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.spring;

import at.molindo.esi4j.core.Esi4J;
import at.molindo.esi4j.core.impl.DefaultEsi4J;
import java.util.Properties;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class Esi4JBean
implements FactoryBean<Esi4J>,
DisposableBean {
    private DefaultEsi4J _esi4j;
    private final Settings _defaultSettings;
    private Settings _settings;
    private Properties _properties;

    public Esi4JBean() {
        this(null);
    }

    public Esi4JBean(Settings defaultSettings) {
        this._defaultSettings = defaultSettings;
    }

    private DefaultEsi4J createEsi4J() {
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        if (this._defaultSettings != null) {
            settings.put(this._defaultSettings);
        }
        if (this._settings != null) {
            settings.put(this._settings);
        }
        if (this._properties != null) {
            settings.put(this._properties);
        }
        this._esi4j = this.newEsi4J(this.processSettings(settings).build());
        this.init(this._esi4j);
        return this._esi4j;
    }

    protected DefaultEsi4J newEsi4J(Settings settings) {
        return new DefaultEsi4J(settings);
    }

    protected ImmutableSettings.Builder processSettings(ImmutableSettings.Builder settings) {
        return settings;
    }

    protected void init(DefaultEsi4J esi4j) {
    }

    public final Esi4J getObject() throws Exception {
        if (this._esi4j == null) {
            this._esi4j = this.createEsi4J();
        }
        return this._esi4j;
    }

    public final Class<?> getObjectType() {
        return DefaultEsi4J.class;
    }

    public final boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this._esi4j != null) {
            this._esi4j.close();
        }
        this.close();
    }

    protected void close() {
    }

    public Properties getProperties() {
        return this._properties;
    }

    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    public Settings getSettings() {
        return this._settings;
    }

    public void setSettings(Settings settings) {
        this._settings = settings;
    }
}

