/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.util;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class Esi4JUtils {
    public static <T> T createObject(Class<T> cls, @Nullable Settings settings) {
        try {
            Constructor<T> constructor = cls.getConstructor(Settings.class);
            try {
                return constructor.newInstance(settings);
            }
            catch (Exception e) {
                throw new ElasticSearchException("Failed to create instance [" + cls + "]", (Throwable)e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<T> constructor = cls.getConstructor(new Class[0]);
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e1) {
                    throw new ElasticSearchException("Failed to create instance [" + cls + "]", (Throwable)e);
                }
            }
            catch (NoSuchMethodException e1) {
                throw new ElasticSearchException("No constructor for [" + cls + "]");
            }
        }
    }

    public static <T> T createObject(Class<T> cls, Object arg, @Nullable Settings settings) {
        try {
            Constructor<T> constructor = cls.getConstructor(arg.getClass(), Settings.class);
            try {
                return constructor.newInstance(arg, settings);
            }
            catch (Exception e) {
                throw new ElasticSearchException("Failed to create instance [" + cls + "]", (Throwable)e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<T> constructor = cls.getConstructor(arg.getClass());
                try {
                    return constructor.newInstance(arg);
                }
                catch (Exception e1) {
                    throw new ElasticSearchException("Failed to create instance [" + cls + "]", (Throwable)e);
                }
            }
            catch (NoSuchMethodException e1) {
                throw new ElasticSearchException("No constructor for [" + cls + "] and argument " + arg.getClass());
            }
        }
    }

    public static Settings getSettings(Settings settings, String oldPrefix, String newPrefix) {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder();
        for (Map.Entry e : settings.getByPrefix(oldPrefix).getAsMap().entrySet()) {
            builder.put(newPrefix + (String)e.getKey(), (String)e.getValue());
        }
        return builder.build();
    }
}

