/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.util;

import at.molindo.utils.data.Function;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.common.unit.TimeValue;

public final class ListenableActionFutureWrapper<F, T>
implements ListenableActionFuture<T> {
    private final ListenableActionFuture<F> _future;
    private final Function<F, T> _function;
    private F _raw;
    private T _result;

    public static <F, T> ListenableActionFutureWrapper<F, T> wrap(ListenableActionFuture<F> future, Function<F, T> function) {
        return new ListenableActionFutureWrapper<F, T>(future, function);
    }

    public ListenableActionFutureWrapper(ListenableActionFuture<F> future, Function<F, T> function) {
        if (future == null) {
            throw new NullPointerException("future");
        }
        if (function == null) {
            throw new NullPointerException("function");
        }
        this._future = future;
        this._function = function;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this._future.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this._future.isCancelled();
    }

    public boolean isDone() {
        return this._future.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return this.applyFunction(this._future.get());
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.applyFunction(this._future.get(timeout, unit));
    }

    public T actionGet() throws ElasticSearchException {
        return this.applyFunction(this._future.actionGet());
    }

    public T actionGet(String timeout) throws ElasticSearchException {
        return this.applyFunction(this._future.actionGet(timeout));
    }

    public T actionGet(long timeoutMillis) throws ElasticSearchException {
        return this.applyFunction(this._future.actionGet(timeoutMillis));
    }

    public T actionGet(long timeout, TimeUnit unit) throws ElasticSearchException {
        return this.applyFunction(this._future.actionGet(timeout, unit));
    }

    public T actionGet(TimeValue timeout) throws ElasticSearchException {
        return this.applyFunction(this._future.actionGet(timeout));
    }

    public Throwable getRootFailure() {
        return this._future.getRootFailure();
    }

    public void addListener(final ActionListener<T> listener) {
        this._future.addListener(new ActionListener<F>(){

            public void onResponse(F response) {
                listener.onResponse(ListenableActionFutureWrapper.this.applyFunction(response));
            }

            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        });
    }

    public void addListener(Runnable listener) {
        this._future.addListener(listener);
    }

    private T applyFunction(F raw) {
        if (this._result == null) {
            this._raw = raw;
            this._result = this._function.apply(raw);
        } else if (this._raw != raw) {
            throw new IllegalArgumentException("always same result expected");
        }
        return this._result;
    }
}

