/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.esi4j.util;

import at.molindo.thirdparty.org.springframework.scheduling.annotation.AsyncResult;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.internal.InternalClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class ListenableAsyncResult<V>
extends AsyncResult<V>
implements ListenableActionFuture<V> {
    private final ThreadPool _threadPool;

    public static <V> ListenableAsyncResult<V> create(V value) {
        return new ListenableAsyncResult<V>(value, null);
    }

    public static <V> ListenableAsyncResult<V> create(V value, Client client, ActionRequest<?> request) {
        return new ListenableAsyncResult<V>(value, request.listenerThreaded() ? ((InternalClient)client).threadPool() : null);
    }

    public ListenableAsyncResult(V value, ThreadPool threadPool) {
        super(value);
        this._threadPool = threadPool;
    }

    public V actionGet() throws ElasticSearchException {
        return (V)this.get();
    }

    public V actionGet(String timeout) throws ElasticSearchException {
        return (V)this.get();
    }

    public V actionGet(long timeoutMillis) throws ElasticSearchException {
        return (V)this.get();
    }

    public V actionGet(long timeout, TimeUnit unit) throws ElasticSearchException {
        return (V)this.get();
    }

    public V actionGet(TimeValue timeout) throws ElasticSearchException {
        return (V)this.get();
    }

    public Throwable getRootFailure() {
        return null;
    }

    public void addListener(ActionListener<V> listener) {
        this.executeListener(listener);
    }

    private void executeListener(final ActionListener<V> listener) {
        this.executeListener(new Runnable(){

            @Override
            public void run() {
                listener.onResponse(ListenableAsyncResult.this.get());
            }
        });
    }

    public void addListener(Runnable listener) {
        this.executeListener(listener);
    }

    private void executeListener(Runnable listener) {
        if (this._threadPool != null) {
            this._threadPool.generic().execute(listener);
        } else {
            listener.run();
        }
    }
}

